/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.IntStream;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.Gender;
import me.chanjar.weixin.cp.bean.WxCpUser;

public class WxCpUserGsonAdapter
implements JsonDeserializer<WxCpUser>,
JsonSerializer<WxCpUser> {
    private static final String EXTERNAL_PROFILE = "external_profile";
    private static final String EXTERNAL_ATTR = "external_attr";
    private static final String EXTRA_ATTR = "extattr";
    private static final String EXTERNAL_POSITION = "external_position";
    private static final String DEPARTMENT = "department";
    private static final String EXTERNAL_CORP_NAME = "external_corp_name";
    private static final String WECHAT_CHANNELS = "wechat_channels";
    private static final String ORDER = "order";
    private static final String POSITIONS = "positions";
    private static final String USER_ID = "userid";
    private static final String NEW_USER_ID = "new_userid";
    private static final String NAME = "name";
    private static final String POSITION = "position";
    private static final String MOBILE = "mobile";
    private static final String GENDER = "gender";
    private static final String EMAIL = "email";
    private static final String BIZ_MAIL = "biz_mail";
    private static final String AVATAR = "avatar";
    private static final String THUMB_AVATAR = "thumb_avatar";
    private static final String ADDRESS = "address";
    private static final String AVATAR_MEDIAID = "avatar_mediaid";
    private static final String STATUS = "status";
    private static final String ENABLE = "enable";
    private static final String ALIAS = "alias";
    private static final String IS_LEADER = "isleader";
    private static final String IS_LEADER_IN_DEPT = "is_leader_in_dept";
    private static final String HIDE_MOBILE = "hide_mobile";
    private static final String ENGLISH_NAME = "english_name";
    private static final String TELEPHONE = "telephone";
    private static final String QR_CODE = "qr_code";
    private static final String TO_INVITE = "to_invite";
    private static final String OPEN_USER_ID = "open_userid";
    private static final String MAIN_DEPARTMENT = "main_department";
    private static final String DIRECT_LEADER = "direct_leader";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String TEXT = "text";
    private static final String WEB = "web";
    private static final String MINIPROGRAM = "miniprogram";
    private static final String URL = "url";
    private static final String TITLE = "title";
    private static final String APPID = "appid";
    private static final String PAGE_PATH = "pagepath";
    private static final String ATTRS = "attrs";
    private static final String NICKNAME = "nickname";

    public WxCpUser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        WxCpUser user = new WxCpUser();
        user.setDepartIds(this.parseJsonArrayToLongArray(o, DEPARTMENT));
        user.setOrders(this.parseJsonArrayToIntegerArray(o, ORDER));
        user.setPositions(this.parseJsonArrayToStringArray(o, POSITIONS));
        user.setUserId(GsonHelper.getString((JsonObject)o, (String)USER_ID));
        user.setName(GsonHelper.getString((JsonObject)o, (String)NAME));
        user.setPosition(GsonHelper.getString((JsonObject)o, (String)POSITION));
        user.setMobile(GsonHelper.getString((JsonObject)o, (String)MOBILE));
        user.setGender(Gender.fromCode(GsonHelper.getString((JsonObject)o, (String)GENDER)));
        user.setEmail(GsonHelper.getString((JsonObject)o, (String)EMAIL));
        user.setBizMail(GsonHelper.getString((JsonObject)o, (String)BIZ_MAIL));
        user.setAvatar(GsonHelper.getString((JsonObject)o, (String)AVATAR));
        user.setThumbAvatar(GsonHelper.getString((JsonObject)o, (String)THUMB_AVATAR));
        user.setAddress(GsonHelper.getString((JsonObject)o, (String)ADDRESS));
        user.setAvatarMediaId(GsonHelper.getString((JsonObject)o, (String)AVATAR_MEDIAID));
        user.setStatus(GsonHelper.getInteger((JsonObject)o, (String)STATUS));
        user.setEnable(GsonHelper.getInteger((JsonObject)o, (String)ENABLE));
        user.setAlias(GsonHelper.getString((JsonObject)o, (String)ALIAS));
        user.setIsLeader(GsonHelper.getInteger((JsonObject)o, (String)IS_LEADER));
        user.setIsLeaderInDept(GsonHelper.getIntArray((JsonObject)o, (String)IS_LEADER_IN_DEPT));
        user.setHideMobile(GsonHelper.getInteger((JsonObject)o, (String)HIDE_MOBILE));
        user.setEnglishName(GsonHelper.getString((JsonObject)o, (String)ENGLISH_NAME));
        user.setTelephone(GsonHelper.getString((JsonObject)o, (String)TELEPHONE));
        user.setQrCode(GsonHelper.getString((JsonObject)o, (String)QR_CODE));
        user.setToInvite(GsonHelper.getBoolean((JsonObject)o, (String)TO_INVITE));
        user.setOpenUserId(GsonHelper.getString((JsonObject)o, (String)OPEN_USER_ID));
        user.setMainDepartment(GsonHelper.getString((JsonObject)o, (String)MAIN_DEPARTMENT));
        user.setDirectLeader(GsonHelper.getStringArray((JsonObject)o, (String)DIRECT_LEADER));
        if (GsonHelper.isNotNull((JsonElement)o.get(EXTRA_ATTR))) {
            this.buildExtraAttrs(o, user);
        }
        if (GsonHelper.isNotNull((JsonElement)o.get(EXTERNAL_PROFILE))) {
            user.setExternalCorpName(GsonHelper.getString((JsonObject)o.getAsJsonObject().get(EXTERNAL_PROFILE).getAsJsonObject(), (String)EXTERNAL_CORP_NAME));
            JsonElement jsonElement = o.get(EXTERNAL_PROFILE).getAsJsonObject().get(WECHAT_CHANNELS);
            if (jsonElement != null) {
                JsonObject asJsonObject = jsonElement.getAsJsonObject();
                user.setWechatChannels(WxCpUser.WechatChannels.builder().nickname(GsonHelper.getString((JsonObject)asJsonObject, (String)NICKNAME)).status(GsonHelper.getInteger((JsonObject)asJsonObject, (String)STATUS)).build());
            }
            this.buildExternalAttrs(o, user);
        }
        user.setExternalPosition(GsonHelper.getString((JsonObject)o, (String)EXTERNAL_POSITION));
        return user;
    }

    private Long[] parseJsonArrayToLongArray(JsonObject o, String key) {
        JsonElement element = o.get(key);
        if (element == null || !element.isJsonArray()) {
            return null;
        }
        JsonArray jsonArray = element.getAsJsonArray();
        return (Long[])IntStream.range(0, jsonArray.size()).mapToObj(i -> jsonArray.get(i).getAsLong()).toArray(Long[]::new);
    }

    private Integer[] parseJsonArrayToIntegerArray(JsonObject o, String key) {
        JsonElement element = o.get(key);
        if (element == null || !element.isJsonArray()) {
            return null;
        }
        JsonArray jsonArray = element.getAsJsonArray();
        return (Integer[])IntStream.range(0, jsonArray.size()).mapToObj(i -> jsonArray.get(i).getAsInt()).toArray(Integer[]::new);
    }

    private String[] parseJsonArrayToStringArray(JsonObject o, String key) {
        JsonElement element = o.get(key);
        if (element == null || !element.isJsonArray()) {
            return null;
        }
        JsonArray jsonArray = element.getAsJsonArray();
        return (String[])IntStream.range(0, jsonArray.size()).mapToObj(i -> jsonArray.get(i).getAsString()).toArray(String[]::new);
    }

    private void buildExtraAttrs(JsonObject o, WxCpUser user) {
        JsonArray attrJsonElements = o.get(EXTRA_ATTR).getAsJsonObject().get(ATTRS).getAsJsonArray();
        for (JsonElement attrJsonElement : attrJsonElements) {
            Integer type = GsonHelper.getInteger((JsonObject)attrJsonElement.getAsJsonObject(), (String)TYPE);
            WxCpUser.Attr attr = new WxCpUser.Attr().setType(type).setName(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)NAME));
            user.getExtAttrs().add(attr);
            if (type == null) {
                attr.setTextValue(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)VALUE));
                continue;
            }
            switch (type) {
                case 0: {
                    JsonElement textJsonElement = attrJsonElement.getAsJsonObject().get(TEXT);
                    if (textJsonElement != null && !textJsonElement.isJsonNull() && textJsonElement.isJsonObject()) {
                        attr.setTextValue(GsonHelper.getString((JsonObject)textJsonElement.getAsJsonObject(), (String)VALUE));
                        break;
                    }
                    attr.setTextValue(null);
                    break;
                }
                case 1: {
                    JsonObject web = attrJsonElement.getAsJsonObject().get(WEB).getAsJsonObject();
                    attr.setWebTitle(GsonHelper.getString((JsonObject)web, (String)TITLE)).setWebUrl(GsonHelper.getString((JsonObject)web, (String)URL));
                    break;
                }
            }
        }
    }

    private void buildExternalAttrs(JsonObject o, WxCpUser user) {
        JsonElement jsonElement = o.get(EXTERNAL_PROFILE).getAsJsonObject().get(EXTERNAL_ATTR);
        if (jsonElement == null) {
            return;
        }
        JsonArray attrJsonElements = jsonElement.getAsJsonArray();
        for (JsonElement element : attrJsonElements) {
            Integer type = GsonHelper.getInteger((JsonObject)element.getAsJsonObject(), (String)TYPE);
            String name = GsonHelper.getString((JsonObject)element.getAsJsonObject(), (String)NAME);
            if (type == null) continue;
            switch (type) {
                case 0: {
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).value(GsonHelper.getString((JsonObject)element.getAsJsonObject().get(TEXT).getAsJsonObject(), (String)VALUE)).build());
                    break;
                }
                case 1: {
                    JsonObject web = element.getAsJsonObject().get(WEB).getAsJsonObject();
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).url(GsonHelper.getString((JsonObject)web, (String)URL)).title(GsonHelper.getString((JsonObject)web, (String)TITLE)).build());
                    break;
                }
                case 2: {
                    JsonObject miniprogram = element.getAsJsonObject().get(MINIPROGRAM).getAsJsonObject();
                    user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).appid(GsonHelper.getString((JsonObject)miniprogram, (String)APPID)).pagePath(GsonHelper.getString((JsonObject)miniprogram, (String)PAGE_PATH)).title(GsonHelper.getString((JsonObject)miniprogram, (String)TITLE)).build());
                    break;
                }
            }
        }
    }

    public JsonElement serialize(WxCpUser user, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        this.addProperty(o, USER_ID, user.getUserId());
        this.addProperty(o, NEW_USER_ID, user.getNewUserId());
        this.addProperty(o, NAME, user.getName());
        this.addArrayProperty(o, DEPARTMENT, user.getDepartIds());
        this.addArrayProperty(o, ORDER, user.getOrders());
        this.addProperty(o, POSITION, user.getPosition());
        this.addArrayProperty(o, POSITIONS, user.getPositions());
        this.addProperty(o, MOBILE, user.getMobile());
        if (user.getGender() != null) {
            o.addProperty(GENDER, user.getGender().getCode());
        }
        this.addProperty(o, EMAIL, user.getEmail());
        this.addProperty(o, BIZ_MAIL, user.getBizMail());
        this.addProperty(o, AVATAR, user.getAvatar());
        this.addProperty(o, THUMB_AVATAR, user.getThumbAvatar());
        this.addProperty(o, ADDRESS, user.getAddress());
        this.addProperty(o, AVATAR_MEDIAID, user.getAvatarMediaId());
        this.addProperty(o, STATUS, user.getStatus());
        this.addProperty(o, ENABLE, user.getEnable());
        this.addProperty(o, ALIAS, user.getAlias());
        this.addProperty(o, IS_LEADER, user.getIsLeader());
        if (user.getIsLeaderInDept() != null && user.getIsLeaderInDept().length > 0) {
            JsonArray ary = new JsonArray();
            Arrays.stream(user.getIsLeaderInDept()).forEach(arg_0 -> ((JsonArray)ary).add(arg_0));
            o.add(IS_LEADER_IN_DEPT, (JsonElement)ary);
        }
        this.addProperty(o, HIDE_MOBILE, user.getHideMobile());
        this.addProperty(o, ENGLISH_NAME, user.getEnglishName());
        this.addProperty(o, TELEPHONE, user.getTelephone());
        this.addProperty(o, QR_CODE, user.getQrCode());
        if (user.getToInvite() != null) {
            o.addProperty(TO_INVITE, user.getToInvite());
        }
        this.addProperty(o, MAIN_DEPARTMENT, user.getMainDepartment());
        this.addArrayProperty(o, DIRECT_LEADER, user.getDirectLeader());
        if (!user.getExtAttrs().isEmpty()) {
            JsonArray attrsJsonArray = new JsonArray();
            for (WxCpUser.Attr attr : user.getExtAttrs()) {
                JsonObject attrJson = GsonHelper.buildJsonObject((Object[])new Object[]{TYPE, attr.getType(), NAME, attr.getName()});
                attrsJsonArray.add((JsonElement)attrJson);
                if (attr.getType() == null) {
                    attrJson.addProperty(NAME, attr.getName());
                    attrJson.addProperty(VALUE, attr.getTextValue());
                    continue;
                }
                switch (attr.getType()) {
                    case 0: {
                        attrJson.add(TEXT, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{VALUE, attr.getTextValue()}));
                        break;
                    }
                    case 1: {
                        attrJson.add(WEB, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{URL, attr.getWebUrl(), TITLE, attr.getWebTitle()}));
                        break;
                    }
                }
            }
            JsonObject attrsJson = new JsonObject();
            attrsJson.add(ATTRS, (JsonElement)attrsJsonArray);
            o.add(EXTRA_ATTR, (JsonElement)attrsJson);
        }
        this.addProperty(o, EXTERNAL_POSITION, user.getExternalPosition());
        JsonObject attrsJson = new JsonObject();
        o.add(EXTERNAL_PROFILE, (JsonElement)attrsJson);
        this.addProperty(attrsJson, EXTERNAL_CORP_NAME, user.getExternalCorpName());
        if (user.getWechatChannels() != null) {
            attrsJson.add(WECHAT_CHANNELS, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{NICKNAME, user.getWechatChannels().getNickname(), STATUS, user.getWechatChannels().getStatus()}));
        }
        if (!user.getExternalAttrs().isEmpty()) {
            JsonArray attrsJsonArray = new JsonArray();
            for (WxCpUser.ExternalAttribute attr : user.getExternalAttrs()) {
                JsonObject attrJson = GsonHelper.buildJsonObject((Object[])new Object[]{TYPE, attr.getType(), NAME, attr.getName()});
                attrsJsonArray.add((JsonElement)attrJson);
                if (attr.getType() == null) continue;
                switch (attr.getType()) {
                    case 0: {
                        attrJson.add(TEXT, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{VALUE, attr.getValue()}));
                        break;
                    }
                    case 1: {
                        attrJson.add(WEB, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{URL, attr.getUrl(), TITLE, attr.getTitle()}));
                        break;
                    }
                    case 2: {
                        attrJson.add(MINIPROGRAM, (JsonElement)GsonHelper.buildJsonObject((Object[])new Object[]{APPID, attr.getAppid(), PAGE_PATH, attr.getPagePath(), TITLE, attr.getTitle()}));
                        break;
                    }
                }
            }
            attrsJson.add(EXTERNAL_ATTR, (JsonElement)attrsJsonArray);
        }
        return o;
    }

    private void addArrayProperty(JsonObject o, String key, Object[] array) {
        if (array != null && array.length > 0) {
            JsonArray jsonArray = new JsonArray();
            Arrays.stream(array).forEach(item -> {
                if (item instanceof Number) {
                    jsonArray.add((Number)item);
                } else {
                    jsonArray.add(item.toString());
                }
            });
            o.add(key, (JsonElement)jsonArray);
        }
    }

    private void addProperty(JsonObject object, String property, Object value) {
        if (value != null) {
            if (value instanceof Number) {
                object.addProperty(property, (Number)value);
            } else if (value instanceof Boolean) {
                object.addProperty(property, (Boolean)value);
            } else {
                object.addProperty(property, value.toString());
            }
        }
    }
}

