/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.configuration.services;

import com.binarywang.spring.starter.wxjava.cp.configuration.services.AbstractWxCpConfiguration;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpMultiProperties;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpMultiRedisProperties;
import com.binarywang.spring.starter.wxjava.cp.service.WxCpMultiServices;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpJedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnProperty(prefix="wx.cp.config-storage", name={"type"}, havingValue="jedis")
public class WxCpInJedisConfiguration
extends AbstractWxCpConfiguration {
    private final WxCpMultiProperties wxCpMultiProperties;
    private final ApplicationContext applicationContext;

    @Bean
    public WxCpMultiServices wxCpMultiServices() {
        return this.wxCpMultiServices(this.wxCpMultiProperties);
    }

    @Override
    protected WxCpDefaultConfigImpl wxCpConfigStorage(WxCpMultiProperties wxCpMultiProperties) {
        return this.configRedis(wxCpMultiProperties);
    }

    private WxCpDefaultConfigImpl configRedis(WxCpMultiProperties wxCpMultiProperties) {
        WxCpMultiRedisProperties wxCpMultiRedisProperties = wxCpMultiProperties.getConfigStorage().getRedis();
        JedisPool jedisPool = wxCpMultiRedisProperties != null && StringUtils.isNotEmpty((CharSequence)wxCpMultiRedisProperties.getHost()) ? this.getJedisPool(wxCpMultiProperties) : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        return new WxCpJedisConfigImpl((Pool)jedisPool, wxCpMultiProperties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool(WxCpMultiProperties wxCpMultiProperties) {
        WxCpMultiProperties.ConfigStorage storage = wxCpMultiProperties.getConfigStorage();
        WxCpMultiRedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxCpInJedisConfiguration(WxCpMultiProperties wxCpMultiProperties, ApplicationContext applicationContext) {
        this.wxCpMultiProperties = wxCpMultiProperties;
        this.applicationContext = applicationContext;
    }
}

