/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.converter;

import com.github.drinkjava2.jdialects.Java8DateUtils;
import com.github.drinkjava2.jdialects.converter.JavaToJdbcConverter;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class BasicJavaToJdbcConverter
implements JavaToJdbcConverter {
    public static final BasicJavaToJdbcConverter instance = new BasicJavaToJdbcConverter();

    @Override
    public Object convert(Object value) {
        if (value == null) {
            return value;
        }
        Class<?> vType = value.getClass();
        if (Date.class == vType) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (Character.class == vType) {
            return ((Character)value).toString();
        }
        if (BigInteger.class == vType) {
            return ((BigInteger)value).longValue();
        }
        if (Boolean.class == vType) {
            return (boolean)((Boolean)value);
        }
        if (Calendar.class.isAssignableFrom(vType)) {
            return new java.sql.Date(((Calendar)value).getTime().getTime());
        }
        if (Temporal.class.isAssignableFrom(vType)) {
            if (LocalDate.class == vType) {
                return Java8DateUtils.localDate2SqlDate((LocalDate)value);
            }
            if (LocalTime.class == vType) {
                return Java8DateUtils.localTime2SqlTime((LocalTime)value);
            }
            if (OffsetTime.class == vType) {
                return Java8DateUtils.offsetTime2SqlTime((OffsetTime)value);
            }
            if (Instant.class == vType) {
                return Java8DateUtils.instant2SqlTimestamp((Instant)value);
            }
            if (LocalDateTime.class == vType) {
                return Java8DateUtils.localDateTime2SqlTimestamp((LocalDateTime)value);
            }
            if (OffsetDateTime.class == vType) {
                return Java8DateUtils.offsetDateTime2SqlTimestamp((OffsetDateTime)value);
            }
            if (ZonedDateTime.class == vType) {
                return Java8DateUtils.zonedDateTime2SqlTimestamp((ZonedDateTime)value);
            }
        }
        return value;
    }
}

