/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.SequenceIdGenerator;
import com.github.drinkjava2.jdialects.id.TableIdGenerator;
import java.sql.Connection;

public class AutoIdGenerator
implements IdGenerator {
    private static final String JDIALECTS_AUTOID_NAME = "jdia_autoid";
    private static final String JDIALECTS_AUTOID_TABLE = "jdia_table_autoid";
    private static final String JDIALECTS_AUTOID_SEQUENCE = "jdia_seq_autoid";
    public static final AutoIdGenerator INSTANCE = new AutoIdGenerator();
    public static final TableIdGenerator TABLE_AUTOID_INSTANCE = new TableIdGenerator("jdia_autoid", "jdia_table_autoid", "idcolumn", "valuecolumn", "next_val", 1, 50);
    public static final SequenceIdGenerator SEQ_AUTOID_INSTANCE = new SequenceIdGenerator("jdia_autoid", "jdia_seq_autoid", 1, 1);

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.AUTO;
    }

    @Override
    public String getIdGenName() {
        return JDIALECTS_AUTOID_NAME;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return true;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        if (dialect.ddlFeatures.supportBasicOrPooledSequence()) {
            return SEQ_AUTOID_INSTANCE.getNextID(con, dialect, dataType);
        }
        return TABLE_AUTOID_INSTANCE.getNextID(con, dialect, dataType);
    }

    public IdGenerator getSequenceOrTableIdGenerator(Dialect dialect) {
        if (dialect.ddlFeatures.supportBasicOrPooledSequence()) {
            return SEQ_AUTOID_INSTANCE;
        }
        return TABLE_AUTOID_INSTANCE;
    }
}

