package com.github.houbb.paradise.common.constant;

/**
 * 路径常量
 *
 * @author houbinbin
 * @version 1.1.0
 */
public final class PathConstant {

    private PathConstant(){}


    /**
     * 根路径
     */
    public static final String ROOT_PATH = "/";

    /**
     * 文件路径前缀
     */
    public static final String FILE_PATH_PREFIX = "filelist:";

    /**
     * 目标class文件路径后缀
     */
    public static final String TARGET_CLASSES_PATH_SUFFIX = "target/classes/";

    /**
     * java源文件默认存放路径
     */
    public static final String SRC_MAIN_JAVA_PATH = "src/main/java/";

    /**
     * 资源文件存放路径
     */
    public static final String SRC_MAIN_RESOURCES_PATH = "/src/main/resources";


}
