/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.support.builder.impl;

import com.github.houbb.paradise.common.support.builder.Builder;
import com.github.houbb.paradise.common.util.reflection.ReflectionUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ToStringBuilder
implements Builder<String> {
    private final Object object;

    public ToStringBuilder(Object object) {
        this.object = object;
    }

    @Override
    public String build() {
        return ToStringBuilder.reflectionToString(this.object);
    }

    public static String reflectionToString(Object object) {
        Class<?> clazz = object.getClass();
        String entityName = clazz.getSimpleName();
        List<Field> fieldList = ReflectionUtil.getAllFieldsList(clazz);
        StringBuilder stringBuilder = new StringBuilder(String.format("%s{", entityName));
        for (int i = 0; i < fieldList.size() - 1; ++i) {
            Field field = fieldList.get(i);
            stringBuilder.append(ToStringBuilder.buildFieldValue(object, field)).append(",");
        }
        stringBuilder.append(ToStringBuilder.buildFieldValue(object, fieldList.get(fieldList.size() - 1)));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String buildFieldValue(Object object, Field field) {
        String format = ToStringBuilder.isType(field, String.class) != false ? "%s='%s'" : "%s=%s";
        StringBuilder stringBuilder = new StringBuilder();
        Method getMethod = ToStringBuilder.getGetMethod(object.getClass(), field);
        try {
            Object fieldValue = getMethod.invoke(object, new Object[0]);
            stringBuilder = null == fieldValue ? new StringBuilder(String.format("%s=null", field.getName())) : new StringBuilder(String.format(format, field.getName(), fieldValue));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private static Method getGetMethod(Class clazz, Field field) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = new PropertyDescriptor(field.getName(), clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return propertyDescriptor.getReadMethod();
    }

    private static Boolean isType(Field field, Class classType) {
        return field.getType().equals(classType);
    }
}

