/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;

public class FilePathUtil {
    public static List<Path> getPathList(String dir, String glob) {
        LinkedList<Path> list = new LinkedList<Path>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Path> getDirFileNames(String dir, String glob) {
        LinkedList<Path> list = new LinkedList<Path>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path.getFileName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Path> getAllDirFileNames(String dir) {
        return FilePathUtil.getDirFileNames(dir, "*.*");
    }

    public static List<String> getDirFileNameStrs(String dir, String glob) {
        LinkedList<String> list = new LinkedList<String>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path.getFileName().toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

