/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.util.ParseUtil;

public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    protected int physicalPackageCount = 0;
    protected int physicalProcessorCount = 0;
    protected int logicalProcessorCount = 0;
    private String cpuVendor;
    private String cpuName;
    private String processorID;
    private String cpuIdentifier;
    private String cpuStepping;
    private String cpuModel;
    private String cpuFamily;
    private long cpuVendorFreq;
    private long cpuMaxFreq;
    private Boolean cpu64;
    private CentralProcessor.LogicalProcessor[] logicalProcessors = this.initProcessorCounts();

    protected abstract CentralProcessor.LogicalProcessor[] initProcessorCounts();

    @Override
    public CentralProcessor.LogicalProcessor[] getLogicalProcessors() {
        return this.logicalProcessors;
    }

    @Override
    public long getMaxFreq() {
        if (this.cpuMaxFreq == 0L) {
            this.cpuMaxFreq = this.queryMaxFreq();
        }
        return this.cpuMaxFreq;
    }

    protected abstract long queryMaxFreq();

    @Override
    public String getVendor() {
        if (this.cpuVendor == null) {
            this.setVendor("");
        }
        return this.cpuVendor;
    }

    @Override
    public String getName() {
        if (this.cpuName == null) {
            this.setName("");
        }
        return this.cpuName;
    }

    @Override
    public String getProcessorID() {
        if (this.processorID == null) {
            this.setProcessorID("");
        }
        return this.processorID;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == 0L) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ").append(this.getFamily());
            sb.append(" Model ").append(this.getModel());
            sb.append(" Stepping ").append(this.getStepping());
            this.setIdentifier(sb.toString());
        }
        return this.cpuIdentifier;
    }

    @Override
    public boolean isCpu64bit() {
        if (this.cpu64 == null) {
            this.setCpu64(false);
        }
        return this.cpu64;
    }

    @Override
    public String getStepping() {
        if (this.cpuStepping == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setStepping(this.parseIdentifier("Stepping"));
        }
        return this.cpuStepping;
    }

    @Override
    public String getModel() {
        if (this.cpuModel == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setModel(this.parseIdentifier("Model"));
        }
        return this.cpuModel;
    }

    @Override
    public String getFamily() {
        if (this.cpuFamily == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setFamily(this.parseIdentifier("Family"));
        }
        return this.cpuFamily;
    }

    protected void setVendor(String cpuVendor) {
        this.cpuVendor = cpuVendor;
    }

    protected void setName(String cpuName) {
        this.cpuName = cpuName;
    }

    protected void setIdentifier(String cpuIdentifier) {
        this.cpuIdentifier = cpuIdentifier;
    }

    protected void setStepping(String cpuStepping) {
        this.cpuStepping = cpuStepping;
    }

    protected void setModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }

    protected void setFamily(String cpuFamily) {
        this.cpuFamily = cpuFamily;
    }

    protected void setVendorFreq(Long cpuVendorFreq) {
        this.cpuVendorFreq = cpuVendorFreq;
    }

    protected void setCpu64(Boolean cpu64) {
        this.cpu64 = cpu64;
    }

    protected void setProcessorID(String processorID) {
        this.processorID = processorID;
    }

    private String parseIdentifier(String id) {
        String[] idSplit = ParseUtil.whitespaces.split(this.getIdentifier());
        boolean found = false;
        for (String s : idSplit) {
            if (found) {
                return s;
            }
            found = s.equals(id);
        }
        return "";
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks(long[] oldTicks) {
        if (oldTicks.length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Tick array " + oldTicks.length + " should have " + CentralProcessor.TickType.values().length + " elements");
        }
        long[] ticks = this.getSystemCpuLoadTicks();
        long total = 0L;
        for (int i = 0; i < ticks.length; ++i) {
            total += ticks[i] - oldTicks[i];
        }
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] + ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - oldTicks[CentralProcessor.TickType.IDLE.getIndex()] - oldTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public double[] getProcessorCpuLoadBetweenTicks(long[][] oldTicks) {
        if (oldTicks.length != this.logicalProcessorCount || oldTicks[0].length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Tick array " + oldTicks.length + " should have " + this.logicalProcessorCount + " arrays, each of which has " + CentralProcessor.TickType.values().length + " elements");
        }
        long[][] ticks = this.getProcessorCpuLoadTicks();
        double[] load = new double[this.logicalProcessorCount];
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long total = 0L;
            for (int i = 0; i < ticks[cpu].length; ++i) {
                total += ticks[cpu][i] - oldTicks[cpu][i];
            }
            long idle = ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] + ticks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()] - oldTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] - oldTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", new Object[]{cpu, total, idle});
            load[cpu] = total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
        }
        return load;
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    public String toString() {
        return this.getName();
    }

    protected String createProcessorID(String stepping, String model, String family, String[] flags) {
        long processorIdBytes = 0L;
        long steppingL = ParseUtil.parseLongOrDefault(stepping, 0L);
        long modelL = ParseUtil.parseLongOrDefault(model, 0L);
        long familyL = ParseUtil.parseLongOrDefault(family, 0L);
        processorIdBytes |= steppingL & 0xFL;
        processorIdBytes |= (modelL & 0xFL) << 4;
        processorIdBytes |= (modelL & 0xF0L) << 16;
        processorIdBytes |= (familyL & 0xFL) << 8;
        processorIdBytes |= (familyL & 0xF0L) << 20;
        String[] stringArray = flags;
        int n = stringArray.length;
        block64: for (int i = 0; i < n; ++i) {
            String flag;
            switch (flag = stringArray[i]) {
                case "fpu": {
                    processorIdBytes |= 0x100000000L;
                    continue block64;
                }
                case "vme": {
                    processorIdBytes |= 0x200000000L;
                    continue block64;
                }
                case "de": {
                    processorIdBytes |= 0x400000000L;
                    continue block64;
                }
                case "pse": {
                    processorIdBytes |= 0x800000000L;
                    continue block64;
                }
                case "tsc": {
                    processorIdBytes |= 0x1000000000L;
                    continue block64;
                }
                case "msr": {
                    processorIdBytes |= 0x2000000000L;
                    continue block64;
                }
                case "pae": {
                    processorIdBytes |= 0x4000000000L;
                    continue block64;
                }
                case "mce": {
                    processorIdBytes |= 0x8000000000L;
                    continue block64;
                }
                case "cx8": {
                    processorIdBytes |= 0x10000000000L;
                    continue block64;
                }
                case "apic": {
                    processorIdBytes |= 0x20000000000L;
                    continue block64;
                }
                case "sep": {
                    processorIdBytes |= 0x80000000000L;
                    continue block64;
                }
                case "mtrr": {
                    processorIdBytes |= 0x100000000000L;
                    continue block64;
                }
                case "pge": {
                    processorIdBytes |= 0x200000000000L;
                    continue block64;
                }
                case "mca": {
                    processorIdBytes |= 0x400000000000L;
                    continue block64;
                }
                case "cmov": {
                    processorIdBytes |= 0x800000000000L;
                    continue block64;
                }
                case "pat": {
                    processorIdBytes |= 0x1000000000000L;
                    continue block64;
                }
                case "pse-36": {
                    processorIdBytes |= 0x2000000000000L;
                    continue block64;
                }
                case "psn": {
                    processorIdBytes |= 0x4000000000000L;
                    continue block64;
                }
                case "clfsh": {
                    processorIdBytes |= 0x8000000000000L;
                    continue block64;
                }
                case "ds": {
                    processorIdBytes |= 0x20000000000000L;
                    continue block64;
                }
                case "acpi": {
                    processorIdBytes |= 0x40000000000000L;
                    continue block64;
                }
                case "mmx": {
                    processorIdBytes |= 0x80000000000000L;
                    continue block64;
                }
                case "fxsr": {
                    processorIdBytes |= 0x100000000000000L;
                    continue block64;
                }
                case "sse": {
                    processorIdBytes |= 0x200000000000000L;
                    continue block64;
                }
                case "sse2": {
                    processorIdBytes |= 0x400000000000000L;
                    continue block64;
                }
                case "ss": {
                    processorIdBytes |= 0x800000000000000L;
                    continue block64;
                }
                case "htt": {
                    processorIdBytes |= 0x1000000000000000L;
                    continue block64;
                }
                case "tm": {
                    processorIdBytes |= 0x2000000000000000L;
                    continue block64;
                }
                case "ia64": {
                    processorIdBytes |= 0x4000000000000000L;
                    continue block64;
                }
                case "pbe": {
                    processorIdBytes |= Long.MIN_VALUE;
                    continue block64;
                }
            }
        }
        return String.format("%016X", processorIdBytes);
    }
}

