/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

final class LinuxFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter VCGEN_FORMATTER = DateTimeFormatter.ofPattern("MMM d uuuu HH:mm:ss", Locale.ENGLISH);

    LinuxFirmware() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null && !this.queryManufacturerFromSysfs() && !this.queryVcGenCmd()) {
            this.manufacturer = "unknown";
        }
        return super.getManufacturer();
    }

    @Override
    public String getDescription() {
        if (this.description == null && !this.queryDescriptionFromSysfs() && !this.queryVcGenCmd()) {
            this.description = "unknown";
        }
        return this.description;
    }

    @Override
    public String getVersion() {
        if (this.version == null && !this.queryVersionFromSysfs() && !this.queryVcGenCmd()) {
            this.version = "unknown";
        }
        return this.version;
    }

    @Override
    public String getReleaseDate() {
        if (this.releaseDate == null && !this.queryReleaseDateFromSysfs() && !this.queryVcGenCmd()) {
            this.releaseDate = "unknown";
        }
        return this.releaseDate;
    }

    @Override
    public String getName() {
        if (this.name == null && !this.queryVcGenCmd()) {
            this.name = "BIOS";
        }
        return this.name;
    }

    private boolean queryManufacturerFromSysfs() {
        String biosVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor").trim();
        if (!biosVendor.isEmpty()) {
            this.manufacturer = biosVendor;
            return true;
        }
        return false;
    }

    private boolean queryDescriptionFromSysfs() {
        String modalias = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/modalias").trim();
        if (!modalias.isEmpty()) {
            this.description = modalias;
            return true;
        }
        return false;
    }

    private boolean queryVersionFromSysfs() {
        String biosVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version").trim();
        if (!biosVersion.isEmpty()) {
            String biosRevision = this.queryBiosRevision();
            this.version = biosVersion + (biosRevision.isEmpty() ? "" : " (revision " + biosRevision + ")");
            return true;
        }
        return false;
    }

    private boolean queryReleaseDateFromSysfs() {
        String biosDate = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date").trim();
        if (!biosDate.isEmpty()) {
            this.releaseDate = ParseUtil.parseMmDdYyyyToYyyyMmDD(biosDate);
            return true;
        }
        return false;
    }

    private String queryBiosRevision() {
        String marker = "Bios Revision:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            if (!checkLine.contains("Bios Revision:")) continue;
            return checkLine.split("Bios Revision:")[1].trim();
        }
        return "";
    }

    private boolean queryVcGenCmd() {
        List<String> vcgencmd = ExecutingCommand.runNative("vcgencmd version");
        if (vcgencmd.size() >= 3) {
            try {
                this.releaseDate = DateTimeFormatter.ISO_LOCAL_DATE.format(VCGEN_FORMATTER.parse(vcgencmd.get(0)));
            }
            catch (DateTimeParseException e) {
                this.releaseDate = "unknown";
            }
            String[] copyright = ParseUtil.whitespaces.split(vcgencmd.get(1));
            this.manufacturer = copyright[copyright.length - 1];
            this.version = vcgencmd.get(2).replace("version ", "");
            this.name = "RPi";
            this.description = "Bootloader";
            return true;
        }
        return false;
    }
}

