/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;

    public static void updateNetworkStats(NetworkIF netIF) {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("link", -1, netIF.getName());
        if (ksp == null) {
            ksp = KstatUtil.kstatLookup(null, -1, netIF.getName());
        }
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            netIF.setBytesSent(KstatUtil.kstatDataLookupLong(ksp, "obytes64"));
            netIF.setBytesRecv(KstatUtil.kstatDataLookupLong(ksp, "rbytes64"));
            netIF.setPacketsSent(KstatUtil.kstatDataLookupLong(ksp, "opackets64"));
            netIF.setPacketsRecv(KstatUtil.kstatDataLookupLong(ksp, "ipackets64"));
            netIF.setOutErrors(KstatUtil.kstatDataLookupLong(ksp, "oerrors"));
            netIF.setInErrors(KstatUtil.kstatDataLookupLong(ksp, "ierrors"));
            netIF.setSpeed(KstatUtil.kstatDataLookupLong(ksp, "ifspeed"));
            netIF.setTimeStamp(ksp.ks_snaptime / 1000000L);
        }
    }
}

