/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsMultiSenderResult;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.github.qcloudsms.SmsSingleVoiceSenderResult;
import com.github.qcloudsms.SmsStatusPullCallbackResult;
import com.github.qcloudsms.SmsStatusPullReplyResult;
import com.github.qcloudsms.SmsVoicePromptSenderResult;
import com.github.qcloudsms.SmsVoiceUploaderResult;
import com.github.qcloudsms.SmsVoiceVerifyCodeSenderResult;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmsSenderUtil {
    protected Random random = new Random();

    SmsSenderUtil() {
    }

    public String stringMD5(String input) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] inputByteArray = input.getBytes();
        messageDigest.update(inputByteArray);
        byte[] resultByteArray = messageDigest.digest();
        return this.byteArrayToHex(resultByteArray);
    }

    protected String strToHash(String str) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] inputByteArray = str.getBytes();
        messageDigest.update(inputByteArray);
        byte[] resultByteArray = messageDigest.digest();
        return this.byteArrayToHex(resultByteArray);
    }

    public String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public int getRandom() {
        return this.random.nextInt(999999) % 900000 + 100000;
    }

    public HttpURLConnection getPostHttpConn(String url) throws Exception {
        URL object = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)object.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestMethod("POST");
        return conn;
    }

    public String calculateSig(String appkey, long random, String msg, long curTime, ArrayList<String> phoneNumbers) throws NoSuchAlgorithmException {
        String phoneNumbersString = phoneNumbers.get(0);
        for (int i = 1; i < phoneNumbers.size(); ++i) {
            phoneNumbersString = phoneNumbersString + "," + phoneNumbers.get(i);
        }
        return this.strToHash(String.format("appkey=%s&random=%d&time=%d&mobile=%s", appkey, random, curTime, phoneNumbersString));
    }

    public String calculateSigForTempl(String appkey, long random, long curTime, ArrayList<String> phoneNumbers) throws NoSuchAlgorithmException {
        String phoneNumbersString = phoneNumbers.get(0);
        for (int i = 1; i < phoneNumbers.size(); ++i) {
            phoneNumbersString = phoneNumbersString + "," + phoneNumbers.get(i);
        }
        return this.strToHash(String.format("appkey=%s&random=%d&time=%d&mobile=%s", appkey, random, curTime, phoneNumbersString));
    }

    public String calculateSigForTempl(String appkey, long random, long curTime, String phoneNumber) throws NoSuchAlgorithmException {
        ArrayList<String> phoneNumbers = new ArrayList<String>();
        phoneNumbers.add(phoneNumber);
        return this.calculateSigForTempl(appkey, random, curTime, phoneNumbers);
    }

    public JSONArray phoneNumbersToJSONArray(String nationCode, ArrayList<String> phoneNumbers) {
        JSONArray tel = new JSONArray();
        int i = 0;
        do {
            JSONObject telElement = new JSONObject();
            telElement.put("nationcode", (Object)nationCode);
            telElement.put("mobile", (Object)phoneNumbers.get(i));
            tel.put((Object)telElement);
        } while (++i < phoneNumbers.size());
        return tel;
    }

    public JSONArray smsParamsToJSONArray(ArrayList<String> params) {
        JSONArray smsParams = new JSONArray();
        for (int i = 0; i < params.size(); ++i) {
            smsParams.put((Object)params.get(i));
        }
        return smsParams;
    }

    public SmsSingleSenderResult jsonToSmsSingleSenderResult(JSONObject json) {
        SmsSingleSenderResult result = new SmsSingleSenderResult();
        result.result = json.getInt("result");
        result.errMsg = json.getString("errmsg");
        if (0 == result.result) {
            result.ext = json.getString("ext");
            result.sid = json.getString("sid");
            result.fee = json.getInt("fee");
        }
        return result;
    }

    public SmsMultiSenderResult jsonToSmsMultiSenderResult(JSONObject json) {
        SmsMultiSenderResult result = new SmsMultiSenderResult();
        result.result = json.getInt("result");
        result.errMsg = json.getString("errmsg");
        if (!json.isNull("ext")) {
            result.ext = json.getString("ext");
        }
        if (0 != result.result) {
            return result;
        }
        result.details = new ArrayList();
        JSONArray details = json.getJSONArray("detail");
        for (int i = 0; i < details.length(); ++i) {
            JSONObject jsonDetail = details.getJSONObject(i);
            SmsMultiSenderResult.Detail detail = result.new SmsMultiSenderResult.Detail();
            detail.result = jsonDetail.getInt("result");
            detail.errMsg = jsonDetail.getString("errmsg");
            detail.phoneNumber = jsonDetail.getString("mobile");
            detail.nationCode = jsonDetail.getString("nationcode");
            if (0 == detail.result) {
                if (!jsonDetail.isNull("sid")) {
                    detail.sid = jsonDetail.getString("sid");
                }
                detail.fee = jsonDetail.getInt("fee");
            }
            result.details.add(detail);
        }
        return result;
    }

    public SmsStatusPullCallbackResult jsonToSmsStatusPullCallbackrResult(JSONObject json) {
        SmsStatusPullCallbackResult result = new SmsStatusPullCallbackResult();
        result.result = json.getInt("result");
        result.errmsg = json.getString("errmsg");
        if (json.isNull("data")) {
            return result;
        }
        result.callbacks = new ArrayList();
        JSONArray datas = json.getJSONArray("data");
        for (int index = 0; index < datas.length(); ++index) {
            JSONObject cb = datas.getJSONObject(index);
            SmsStatusPullCallbackResult.Callback callback = new SmsStatusPullCallbackResult.Callback(result);
            callback.user_receive_time = cb.getString("user_receive_time");
            callback.nationcode = cb.getString("nationcode");
            callback.mobile = cb.getString("mobile");
            callback.report_status = cb.getString("report_status");
            callback.errmsg = cb.getString("errmsg");
            callback.description = cb.getString("description");
            callback.sid = cb.getString("sid");
            result.callbacks.add(callback);
        }
        return result;
    }

    public SmsStatusPullReplyResult jsonToSmsStatusPullReplyResult(JSONObject json) {
        SmsStatusPullReplyResult result = new SmsStatusPullReplyResult();
        result.result = json.getInt("result");
        result.errmsg = json.getString("errmsg");
        if (0 == result.result) {
            result.count = json.getInt("count");
        }
        if (json.isNull("data")) {
            return result;
        }
        result.replys = new ArrayList();
        JSONArray datas = json.getJSONArray("data");
        for (int index = 0; index < datas.length(); ++index) {
            JSONObject reply_json = datas.getJSONObject(index);
            SmsStatusPullReplyResult.Reply reply = new SmsStatusPullReplyResult.Reply(result);
            reply.nationcode = reply_json.getString("nationcode");
            reply.mobile = reply_json.getString("mobile");
            reply.sign = reply_json.getString("sign");
            reply.text = reply_json.getString("text");
            reply.time = reply_json.getLong("time");
            result.replys.add(reply);
        }
        return result;
    }

    public SmsVoiceVerifyCodeSenderResult jsonToSmsVoiceVerifyCodeSenderResult(JSONObject json) {
        SmsVoiceVerifyCodeSenderResult result = new SmsVoiceVerifyCodeSenderResult();
        result.result = json.getInt("result");
        if (!json.isNull("errmsg")) {
            result.errmsg = json.getString("errmsg");
        }
        if (0 == result.result) {
            result.ext = json.getString("ext");
            result.callid = json.getString("callid");
        }
        return result;
    }

    public SmsVoicePromptSenderResult jsonToSmsVoicePromptSenderResult(JSONObject json) {
        SmsVoicePromptSenderResult result = new SmsVoicePromptSenderResult();
        result.result = json.getInt("result");
        if (!json.isNull("errmsg")) {
            result.errmsg = json.getString("errmsg");
        }
        if (0 == result.result) {
            result.ext = json.getString("ext");
            result.callid = json.getString("callid");
        }
        return result;
    }

    public SmsVoiceUploaderResult jsonToSmsVoiceUploaderResult(JSONObject json) {
        SmsVoiceUploaderResult result = new SmsVoiceUploaderResult();
        result.result = json.getInt("result");
        if (!json.isNull("msg")) {
            result.msg = json.getString("msg");
        }
        if (0 == result.result) {
            result.file = json.getString("file");
        }
        return result;
    }

    public SmsSingleVoiceSenderResult jsonToSmsSingleVoiceSenderResult(JSONObject json) {
        SmsSingleVoiceSenderResult result = new SmsSingleVoiceSenderResult();
        result.result = json.getInt("result");
        if (!json.isNull("errmsg")) {
            result.errmsg = json.getString("errmsg");
        }
        if (0 == result.result) {
            result.ext = json.getString("ext");
            result.callid = json.getString("callid");
        }
        return result;
    }
}

