/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.annotation.LocalCache;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.to.CacheConfigTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.LocalCacheWrapper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboCacheManager
implements ICacheManager {
    private static final Logger log = LoggerFactory.getLogger(ComboCacheManager.class);
    private final AbstractScriptParser scriptParser;
    private ICacheManager localCache;
    private ICacheManager remoteCache;

    public ComboCacheManager(ICacheManager localCache, ICacheManager remoteCache, AbstractScriptParser scriptParser) {
        this.localCache = localCache;
        this.remoteCache = remoteCache;
        this.scriptParser = scriptParser;
    }

    public void setCache(CacheKeyTO cacheKey, CacheWrapper<Object> result, CacheConfigTO method) throws CacheCenterConnectionException {
        if (method.hasLocalCache()) {
            LocalCache lCache = method.getLocalCache();
            this.setLocalCache(lCache, cacheKey, result, method);
            if (lCache.localOnly()) {
                return;
            }
        }
        this.remoteCache.setCache(cacheKey, result, method);
    }

    public void mset(CacheConfigTO method, Collection<MSetParam> params) throws CacheCenterConnectionException {
        if (method.hasLocalCache()) {
            LocalCache lCache = method.getLocalCache();
            for (MSetParam param : params) {
                if (param == null) continue;
                this.setLocalCache(lCache, param.getCacheKey(), (CacheWrapper<Object>)param.getResult(), method);
            }
            if (lCache.localOnly()) {
                return;
            }
        }
        this.remoteCache.mset(method, params);
    }

    private void setLocalCache(LocalCache lCache, CacheKeyTO cacheKey, CacheWrapper<Object> result, CacheConfigTO method) {
        try {
            LocalCacheWrapper localResult = new LocalCacheWrapper();
            localResult.setLastLoadTime(System.currentTimeMillis());
            int expire = this.scriptParser.getRealExpire(lCache.expire(), lCache.expireExpression(), null, result.getCacheObject());
            localResult.setExpire(expire);
            localResult.setCacheObject(result.getCacheObject());
            localResult.setRemoteExpire(result.getExpire());
            localResult.setRemoteLastLoadTime(result.getLastLoadTime());
            this.localCache.setCache(cacheKey, result, method);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public CacheWrapper<Object> get(CacheKeyTO key, CacheConfigTO method) throws CacheCenterConnectionException {
        CacheWrapper result;
        LocalCache lCache = null;
        if (method.hasLocalCache()) {
            lCache = method.getLocalCache();
        }
        String threadName = Thread.currentThread().getName();
        if (null != lCache && !threadName.startsWith("autoLoadThread-") && null != (result = this.localCache.get(key, method))) {
            if (result instanceof LocalCacheWrapper) {
                LocalCacheWrapper localResult = (LocalCacheWrapper)result;
                return new CacheWrapper(localResult.getCacheObject(), localResult.getRemoteExpire(), localResult.getRemoteLastLoadTime());
            }
            return result;
        }
        result = this.remoteCache.get(key, method);
        if (null != lCache && result != null) {
            this.setLocalCache(lCache, key, (CacheWrapper<Object>)result, method);
        }
        return result;
    }

    public Map<CacheKeyTO, CacheWrapper<Object>> mget(CacheConfigTO method, Type returnType, Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        HashMap<CacheKeyTO, CacheWrapper<Object>> all;
        LocalCache lCache = null;
        if (!method.hasLocalCache()) {
            return this.remoteCache.mget(method, returnType, keys);
        }
        lCache = method.getLocalCache();
        String threadName = Thread.currentThread().getName();
        Map remoteResults = null;
        if (!threadName.startsWith("autoLoadThread-")) {
            all = new HashMap(keys.size());
            Map localResults = this.localCache.mget(method, returnType, keys);
            if (null != localResults && !localResults.isEmpty()) {
                for (Map.Entry item : localResults.entrySet()) {
                    CacheWrapper result = (CacheWrapper)item.getValue();
                    if (result instanceof LocalCacheWrapper) {
                        LocalCacheWrapper localResult = (LocalCacheWrapper)result;
                        CacheWrapper result2 = new CacheWrapper(localResult.getCacheObject(), localResult.getRemoteExpire(), localResult.getRemoteLastLoadTime());
                        all.put((CacheKeyTO)item.getKey(), (CacheWrapper<Object>)result2);
                        continue;
                    }
                    all.put((CacheKeyTO)item.getKey(), (CacheWrapper<Object>)result);
                }
            }
            if (all.size() < keys.size()) {
                HashSet<CacheKeyTO> unCachekeys = new HashSet<CacheKeyTO>(keys.size() - all.size());
                for (CacheKeyTO key : keys) {
                    if (all.containsKey(key)) continue;
                    unCachekeys.add(key);
                }
                remoteResults = this.remoteCache.mget(method, returnType, keys);
                if (null != remoteResults && !remoteResults.isEmpty()) {
                    all.putAll(remoteResults);
                }
            }
        } else {
            remoteResults = this.remoteCache.mget(method, returnType, keys);
            all = remoteResults;
        }
        if (null != remoteResults && !remoteResults.isEmpty()) {
            for (Map.Entry item : remoteResults.entrySet()) {
                this.setLocalCache(lCache, (CacheKeyTO)item.getKey(), (CacheWrapper<Object>)((CacheWrapper)item.getValue()), method);
            }
        }
        return all;
    }

    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        this.localCache.delete(keys);
        this.remoteCache.delete(keys);
    }
}

