/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.Magic;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.CacheConfigTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicHandler {
    private static final Logger log = LoggerFactory.getLogger(MagicHandler.class);
    private final CacheHandler cacheHandler;
    private final CacheAopProxyChain pjp;
    private final Cache cache;
    private final Magic magic;
    private final Object[] arguments;
    private final int iterableArgIndex;
    private final Object[] iterableArrayArg;
    private final Collection<Object> iterableCollectionArg;
    private final Method method;
    private CacheConfigTO methodInfo;
    private final Class<?> returnType;
    private CacheKeyTO[] cacheKeys;
    private final Class<?>[] parameterTypes;
    private final Object target;
    private final String methodName;

    public MagicHandler(CacheHandler cacheHandler, CacheAopProxyChain pjp, Cache cache) {
        this.cacheHandler = cacheHandler;
        this.pjp = pjp;
        this.cache = cache;
        this.magic = cache.magic();
        this.arguments = pjp.getArgs();
        this.iterableArgIndex = this.magic.iterableArgIndex();
        if (this.iterableArgIndex >= 0 && this.iterableArgIndex < this.arguments.length) {
            Object tmpArg = this.arguments[this.iterableArgIndex];
            if (tmpArg instanceof Collection) {
                this.iterableCollectionArg = (Collection)tmpArg;
                this.iterableArrayArg = null;
            } else if (tmpArg.getClass().isArray()) {
                this.iterableArrayArg = (Object[])tmpArg;
                this.iterableCollectionArg = null;
            } else {
                this.iterableArrayArg = null;
                this.iterableCollectionArg = null;
            }
        } else {
            this.iterableArrayArg = null;
            this.iterableCollectionArg = null;
        }
        this.method = pjp.getMethod();
        this.methodInfo = new CacheConfigTO(this.method);
        this.returnType = this.method.getReturnType();
        this.parameterTypes = this.method.getParameterTypes();
        this.target = pjp.getTarget();
        this.methodName = pjp.getMethod().getName();
    }

    public static boolean isMagic(Cache cache, Method method) throws Exception {
        boolean rv;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Magic magic = cache.magic();
        int iterableArgIndex = magic.iterableArgIndex();
        String key = magic.key();
        boolean bl = rv = null != key && key.length() > 0;
        if (rv) {
            Class<?> returnType;
            if (parameterTypes.length > 0) {
                if (iterableArgIndex < 0) {
                    throw new Exception("iterableArgIndex\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e0");
                }
                if (iterableArgIndex >= parameterTypes.length) {
                    throw new Exception("iterableArgIndex\u5fc5\u987b\u5c0f\u4e8e\u53c2\u6570\u957f\u5ea6\uff1a" + parameterTypes.length);
                }
                Class<?> tmp = parameterTypes[iterableArgIndex];
                if (!tmp.isArray() && !Collection.class.isAssignableFrom(tmp)) {
                    throw new Exception("magic\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570" + iterableArgIndex + "\u5fc5\u987b\u662f\u6570\u7ec4\u6216Collection\u7684\u7c7b\u578b");
                }
            }
            if (!(returnType = method.getReturnType()).isArray() && !Collection.class.isAssignableFrom(returnType)) {
                throw new Exception("magic\u6a21\u5f0f\u4e0b\uff0c\u8fd4\u56de\u503c\u5fc5\u987b\u662f\u6570\u7ec4\u6216Collection\u7684\u7c7b\u578b");
            }
        }
        return rv;
    }

    private Collection<Object> newCollection(Class<?> collectionType, int resSize) throws Exception {
        AbstractCollection res;
        if (LinkedList.class.isAssignableFrom(collectionType)) {
            if (resSize == 0) {
                return Collections.emptyList();
            }
            res = new LinkedList<Object>();
        } else if (List.class.isAssignableFrom(collectionType)) {
            if (resSize == 0) {
                return Collections.emptyList();
            }
            res = new ArrayList(resSize);
        } else if (LinkedHashSet.class.isAssignableFrom(collectionType)) {
            if (resSize == 0) {
                return Collections.emptySet();
            }
            res = new LinkedHashSet(resSize);
        } else if (Set.class.isAssignableFrom(collectionType)) {
            if (resSize == 0) {
                return Collections.emptySet();
            }
            res = new HashSet(resSize);
        } else {
            throw new Exception("Unsupported type:" + collectionType.getName());
        }
        return res;
    }

    private Type getRealReturnType() {
        if (this.returnType.isArray()) {
            return this.returnType.getComponentType();
        }
        return ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
    }

    public Object magic() throws Throwable {
        if (this.parameterTypes.length == 0) {
            Object newValue = this.cacheHandler.getData(this.pjp, null);
            this.writeMagicCache(newValue);
            return newValue;
        }
        Map<CacheKeyTO, Object> keyArgMap = this.getCacheKeyForMagic();
        if (null == keyArgMap || keyArgMap.isEmpty()) {
            if (this.returnType.isArray()) {
                return Array.newInstance(this.returnType.getComponentType(), 0);
            }
            return this.newCollection(this.returnType, 0);
        }
        Type returnItemType = this.getRealReturnType();
        Map<CacheKeyTO, CacheWrapper<Object>> cacheValues = this.cacheHandler.mget(this.methodInfo, returnItemType, keyArgMap.keySet());
        int argSize = keyArgMap.size() - cacheValues.size();
        if (argSize <= 0) {
            return this.convertToReturnObject(cacheValues, null, Collections.emptyMap());
        }
        Object[] args = this.getUnmatchArg(keyArgMap, cacheValues, argSize);
        Object newValue = this.cacheHandler.getData(this.pjp, args);
        args[this.iterableArgIndex] = null;
        Map<CacheKeyTO, MSetParam> unmatchCache = this.writeMagicCache(newValue, args, cacheValues, keyArgMap);
        return this.convertToReturnObject(cacheValues, newValue, unmatchCache);
    }

    private Object[] getUnmatchArg(Map<CacheKeyTO, Object> keyArgMap, Map<CacheKeyTO, CacheWrapper<Object>> cacheValues, int argSize) throws Exception {
        Object[] unmatchArg;
        Iterator<Map.Entry<CacheKeyTO, Object>> keyArgMapIt = keyArgMap.entrySet().iterator();
        if (null != this.iterableCollectionArg) {
            Object[] argList = this.newCollection(this.iterableCollectionArg.getClass(), argSize);
            while (keyArgMapIt.hasNext()) {
                Map.Entry<CacheKeyTO, Object> item = keyArgMapIt.next();
                if (cacheValues.containsKey(item.getKey())) continue;
                argList.add(item.getValue());
            }
            unmatchArg = argList;
        } else {
            Object arg = this.iterableArrayArg[0];
            Object[] args = (Object[])Array.newInstance(arg.getClass(), argSize);
            int i = 0;
            while (keyArgMapIt.hasNext()) {
                Map.Entry<CacheKeyTO, Object> item = keyArgMapIt.next();
                if (cacheValues.containsKey(item.getKey())) continue;
                args[i] = item.getValue();
                ++i;
            }
            unmatchArg = args;
        }
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            args[i] = i == this.iterableArgIndex ? unmatchArg : this.arguments[i];
        }
        return args;
    }

    private Map<CacheKeyTO, MSetParam> writeMagicCache(Object newValue) throws Exception {
        HashMap<CacheKeyTO, MSetParam> unmatchCache;
        if (null == newValue) {
            return Collections.emptyMap();
        }
        Object[] args = null;
        if (newValue.getClass().isArray()) {
            Object[] newValues = (Object[])newValue;
            unmatchCache = new HashMap<CacheKeyTO, MSetParam>(newValues.length);
            for (Object value : newValues) {
                MSetParam mSetParam = this.genCacheWrapper(value, args);
                unmatchCache.put(mSetParam.getCacheKey(), mSetParam);
            }
        } else if (newValue instanceof Collection) {
            Collection newValues = (Collection)newValue;
            unmatchCache = new HashMap(newValues.size());
            for (Object value : newValues) {
                MSetParam mSetParam = this.genCacheWrapper(value, args);
                unmatchCache.put(mSetParam.getCacheKey(), mSetParam);
            }
        } else {
            throw new Exception("Magic\u6a21\u5f0f\u8fd4\u56de\u503c\uff0c\u53ea\u5141\u8bb8\u662f\u6570\u7ec4\u6216Collection\u7c7b\u578b\u7684");
        }
        if (null != unmatchCache && unmatchCache.size() > 0) {
            this.cacheHandler.mset(this.methodInfo, unmatchCache.values());
        }
        return unmatchCache;
    }

    private Map<CacheKeyTO, MSetParam> writeMagicCache(Object newValue, Object[] args, Map<CacheKeyTO, CacheWrapper<Object>> cacheValues, Map<CacheKeyTO, Object> keyArgMap) throws Exception {
        int cachedSize = null == cacheValues ? 0 : cacheValues.size();
        int unmatchSize = keyArgMap.size() - cachedSize;
        HashMap<CacheKeyTO, MSetParam> unmatchCache = new HashMap<CacheKeyTO, MSetParam>(unmatchSize);
        if (null != newValue) {
            Object newValues;
            if (newValue.getClass().isArray()) {
                for (Object value : newValues = (Object[])newValue) {
                    MSetParam mSetParam = this.genCacheWrapper(value, args);
                    unmatchCache.put(mSetParam.getCacheKey(), mSetParam);
                }
            } else if (newValue instanceof Collection) {
                newValues = (Collection)newValue;
                Iterator iterator = newValues.iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    MSetParam mSetParam = this.genCacheWrapper(value, args);
                    unmatchCache.put(mSetParam.getCacheKey(), mSetParam);
                }
            } else {
                throw new Exception("Magic\u6a21\u5f0f\u8fd4\u56de\u503c\uff0c\u53ea\u5141\u8bb8\u662f\u6570\u7ec4\u6216Collection\u7c7b\u578b\u7684");
            }
        }
        if (unmatchCache.size() < unmatchSize) {
            Set<CacheKeyTO> cacheKeySet = keyArgMap.keySet();
            for (CacheKeyTO cacheKeyTO : cacheKeySet) {
                if (unmatchCache.containsKey(cacheKeyTO) || null != cacheValues && cacheValues.containsKey(cacheKeyTO)) continue;
                MSetParam mSetParam = this.genCacheWrapper(cacheKeyTO, null, args);
                unmatchCache.put(mSetParam.getCacheKey(), mSetParam);
            }
        }
        if (null != unmatchCache && unmatchCache.size() > 0) {
            this.cacheHandler.mset(this.methodInfo, unmatchCache.values());
        }
        return unmatchCache;
    }

    private MSetParam genCacheWrapper(Object value, Object[] args) throws Exception {
        String keyExpression = this.magic.key();
        String hfieldExpression = this.magic.hfield();
        CacheKeyTO cacheKeyTO = this.cacheHandler.getCacheKey(this.target, this.methodName, args, keyExpression, hfieldExpression, value, true);
        int expire = this.cacheHandler.getScriptParser().getRealExpire(this.cache.expire(), this.cache.expireExpression(), args, value);
        return new MSetParam(cacheKeyTO, new CacheWrapper(value, expire));
    }

    private MSetParam genCacheWrapper(CacheKeyTO cacheKeyTO, Object value, Object[] args) throws Exception {
        int expire = this.cacheHandler.getScriptParser().getRealExpire(this.cache.expire(), this.cache.expireExpression(), args, value);
        return new MSetParam(cacheKeyTO, new CacheWrapper(value, expire));
    }

    private Object convertToReturnObject(Map<CacheKeyTO, CacheWrapper<Object>> cacheValues, Object newValue, Map<CacheKeyTO, MSetParam> unmatchCache) throws Throwable {
        int resSize;
        if (this.returnType.isArray()) {
            int resSize2;
            if (this.magic.returnNullValue()) {
                resSize2 = this.cacheKeys.length;
            } else {
                Object[] newValues = (Object[])newValue;
                resSize2 = cacheValues.size() + (null == newValues ? 0 : newValues.length);
            }
            Object res = Array.newInstance(this.returnType.getComponentType(), resSize2);
            int ind = 0;
            for (CacheKeyTO cacheKeyTO : this.cacheKeys) {
                Object val = this.getValueFormCacheOrDatasource(cacheKeyTO, cacheValues, unmatchCache);
                if (!this.magic.returnNullValue() && null == val) continue;
                Array.set(res, ind, val);
                ++ind;
            }
            return res;
        }
        if (this.magic.returnNullValue()) {
            resSize = this.cacheKeys.length;
        } else {
            Collection newValues = (Collection)newValue;
            resSize = cacheValues.size() + (null == newValues ? 0 : newValues.size());
        }
        Collection<Object> res = this.newCollection(this.returnType, resSize);
        for (CacheKeyTO cacheKeyTO : this.cacheKeys) {
            Object val = this.getValueFormCacheOrDatasource(cacheKeyTO, cacheValues, unmatchCache);
            if (!this.magic.returnNullValue() && null == val) continue;
            res.add(val);
        }
        return res;
    }

    private Object getValueFormCacheOrDatasource(CacheKeyTO cacheKeyTO, Map<CacheKeyTO, CacheWrapper<Object>> cacheValues, Map<CacheKeyTO, MSetParam> unmatchCache) {
        boolean isCache = false;
        CacheWrapper cacheWrapper = cacheValues.get(cacheKeyTO);
        if (null == cacheWrapper) {
            MSetParam mSetParam = unmatchCache.get(cacheKeyTO);
            if (null != mSetParam) {
                cacheWrapper = mSetParam.getResult();
            }
        } else {
            isCache = true;
        }
        Object val = null;
        if (null != cacheWrapper) {
            val = cacheWrapper.getCacheObject();
        }
        if (log.isDebugEnabled()) {
            String from = isCache ? "cache" : "datasource";
            String message = "the data for key:" + cacheKeyTO + " is from " + from;
            message = null != val ? message + ", value is not null" : message + ", value is null";
            if (null != cacheWrapper) {
                message = message + ", expire :" + cacheWrapper.getExpire();
            }
            log.debug(message);
        }
        return val;
    }

    private Map<CacheKeyTO, Object> getCacheKeyForMagic() {
        HashMap<CacheKeyTO, Object> keyArgMap;
        block3: {
            block2: {
                keyArgMap = null;
                if (null == this.iterableCollectionArg) break block2;
                this.cacheKeys = new CacheKeyTO[this.iterableCollectionArg.size()];
                keyArgMap = new HashMap<CacheKeyTO, Object>(this.iterableCollectionArg.size());
                int ind = 0;
                for (Object arg : this.iterableCollectionArg) {
                    CacheKeyTO cacheKeyTO = this.buildCacheKey(arg);
                    keyArgMap.put(cacheKeyTO, arg);
                    this.cacheKeys[ind] = cacheKeyTO;
                    ++ind;
                }
                break block3;
            }
            if (null == this.iterableArrayArg) break block3;
            this.cacheKeys = new CacheKeyTO[this.iterableArrayArg.length];
            keyArgMap = new HashMap(this.iterableArrayArg.length);
            for (int ind = 0; ind < this.iterableArrayArg.length; ++ind) {
                Object arg = this.iterableArrayArg[ind];
                CacheKeyTO cacheKeyTO = this.buildCacheKey(arg);
                keyArgMap.put(cacheKeyTO, arg);
                this.cacheKeys[ind] = cacheKeyTO;
            }
        }
        return keyArgMap;
    }

    private CacheKeyTO buildCacheKey(Object arg) {
        Object[] tmpArgs = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            tmpArgs[i] = i == this.iterableArgIndex ? arg : this.arguments[i];
        }
        String keyExpression = this.cache.key();
        String hfieldExpression = this.cache.hfield();
        return this.cacheHandler.getCacheKey(this.target, this.methodName, tmpArgs, keyExpression, hfieldExpression, null, false);
    }
}

