/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.DataLoaderFactory;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshHandler {
    private static final Logger log = LoggerFactory.getLogger(RefreshHandler.class);
    private static final int REFRESH_MIN_EXPIRE = 120;
    private static final int ONE_THOUSAND_MS = 1000;
    private final ThreadPoolExecutor refreshThreadPool;
    private final ConcurrentHashMap<CacheKeyTO, Byte> refreshing;
    private final CacheHandler cacheHandler;

    public RefreshHandler(CacheHandler cacheHandler, AutoLoadConfig config) {
        this.cacheHandler = cacheHandler;
        int corePoolSize = config.getRefreshThreadPoolSize();
        int maximumPoolSize = config.getRefreshThreadPoolMaxSize();
        int keepAliveTime = config.getRefreshThreadPoolkeepAliveTime();
        TimeUnit unit = TimeUnit.MINUTES;
        int queueCapacity = config.getRefreshQueueCapacity();
        this.refreshing = new ConcurrentHashMap(queueCapacity);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        RefreshRejectedExecutionHandler rejectedHandler = new RefreshRejectedExecutionHandler();
        this.refreshThreadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final String namePrefix = "autoload-cache-RefreshHandler-";

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "autoload-cache-RefreshHandler-" + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        }, rejectedHandler);
    }

    public void removeTask(CacheKeyTO cacheKey) {
        this.refreshing.remove(cacheKey);
    }

    public void doRefresh(CacheAopProxyChain pjp, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) {
        int expire = cacheWrapper.getExpire();
        if (expire < 120) {
            return;
        }
        int alarmTime = cache.alarmTime();
        long timeout = alarmTime > 0 && alarmTime < expire ? (long)(expire - alarmTime) : (expire >= 600 ? (long)(expire - 120) : (long)(expire - 60));
        if (System.currentTimeMillis() - cacheWrapper.getLastLoadTime() < timeout * 1000L) {
            return;
        }
        Byte tmpByte = this.refreshing.get(cacheKey);
        if (null != tmpByte) {
            return;
        }
        tmpByte = 1;
        if (null == this.refreshing.putIfAbsent(cacheKey, tmpByte)) {
            try {
                this.refreshThreadPool.execute(new RefreshTask(pjp, cache, cacheKey, cacheWrapper));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.refreshThreadPool.shutdownNow();
        try {
            this.refreshThreadPool.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class RefreshRejectedExecutionHandler
    implements RejectedExecutionHandler {
        RefreshRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                Runnable last = (Runnable)e.getQueue().poll();
                if (last instanceof RefreshTask) {
                    RefreshTask lastTask = (RefreshTask)last;
                    RefreshHandler.this.refreshing.remove(lastTask.getCacheKey());
                }
                e.execute(r);
            }
        }
    }

    class RefreshTask
    implements Runnable {
        private final CacheAopProxyChain pjp;
        private final Cache cache;
        private final CacheKeyTO cacheKey;
        private final CacheWrapper<Object> cacheWrapper;
        private final Object[] arguments;

        public RefreshTask(CacheAopProxyChain pjp, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) throws Exception {
            this.pjp = pjp;
            this.cache = cache;
            this.cacheKey = cacheKey;
            this.cacheWrapper = cacheWrapper;
            this.arguments = cache.argumentsDeepcloneEnable() ? RefreshHandler.this.cacheHandler.getCloner().deepCloneMethodArgs(pjp.getMethod(), pjp.getArgs()) : pjp.getArgs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataLoader dataLoader;
            if (RefreshHandler.this.cacheHandler.getAutoLoadConfig().isDataLoaderPooled()) {
                DataLoaderFactory factory = DataLoaderFactory.getInstance();
                dataLoader = factory.getDataLoader();
            } else {
                dataLoader = new DataLoader();
            }
            CacheWrapper newCacheWrapper = null;
            boolean isFirst = false;
            try {
                newCacheWrapper = dataLoader.init(this.pjp, this.cacheKey, this.cache, RefreshHandler.this.cacheHandler, this.arguments).loadData().getCacheWrapper();
            }
            catch (Throwable ex) {
                log.error(ex.getMessage(), ex);
            }
            finally {
                isFirst = dataLoader.isFirst();
                if (RefreshHandler.this.cacheHandler.getAutoLoadConfig().isDataLoaderPooled()) {
                    DataLoaderFactory factory = DataLoaderFactory.getInstance();
                    factory.returnObject(dataLoader);
                }
            }
            if (isFirst) {
                if (null == newCacheWrapper && null != this.cacheWrapper) {
                    int newExpire = this.cacheWrapper.getExpire() / 2;
                    if (newExpire < 120) {
                        newExpire = 120;
                    }
                    newCacheWrapper = new CacheWrapper(this.cacheWrapper.getCacheObject(), newExpire);
                }
                try {
                    if (null != newCacheWrapper) {
                        RefreshHandler.this.cacheHandler.writeCache(this.pjp, this.arguments, this.cache, this.cacheKey, newCacheWrapper);
                    }
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
            RefreshHandler.this.refreshing.remove(this.cacheKey);
        }

        public CacheKeyTO getCacheKey() {
            return this.cacheKey;
        }
    }
}

