/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.exception.LoadDataTimeOutException;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheConfigTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.ProcessingTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoader {
    private static final Logger log = LoggerFactory.getLogger(DataLoader.class);
    private CacheHandler cacheHandler;
    private CacheAopProxyChain pjp;
    private CacheConfigTO methodInfo;
    private CacheKeyTO cacheKey;
    private Cache cache;
    private Object[] arguments;
    private AutoLoadTO autoLoadTO;
    private boolean isFirst;
    private long loadDataUseTime;
    private CacheWrapper<Object> cacheWrapper;
    private int tryCnt = 0;

    public DataLoader init(CacheAopProxyChain pjp, AutoLoadTO autoLoadTO, CacheKeyTO cacheKey, Cache cache, CacheHandler cacheHandler) {
        this.cacheHandler = cacheHandler;
        this.pjp = pjp;
        this.methodInfo = new CacheConfigTO(pjp.getMethod());
        this.cacheKey = cacheKey;
        this.cache = cache;
        this.autoLoadTO = autoLoadTO;
        this.arguments = null == autoLoadTO ? pjp.getArgs() : autoLoadTO.getArgs();
        this.loadDataUseTime = 0L;
        this.tryCnt = 0;
        return this;
    }

    public DataLoader init(CacheAopProxyChain pjp, CacheKeyTO cacheKey, Cache cache, CacheHandler cacheHandler, Object[] arguments) {
        this.cacheHandler = cacheHandler;
        this.pjp = pjp;
        this.cacheKey = cacheKey;
        this.cache = cache;
        this.autoLoadTO = null;
        this.arguments = arguments;
        this.loadDataUseTime = 0L;
        this.tryCnt = 0;
        return this;
    }

    public DataLoader init(CacheAopProxyChain pjp, Cache cache, CacheHandler cacheHandler) {
        return this.init(pjp, null, null, cache, cacheHandler);
    }

    public DataLoader init(CacheAopProxyChain pjp, CacheKeyTO cacheKey, Cache cache, CacheHandler cacheHandler) {
        return this.init(pjp, null, cacheKey, cache, cacheHandler);
    }

    public void reset() {
        this.cacheHandler = null;
        this.pjp = null;
        this.cacheKey = null;
        this.cache = null;
        this.autoLoadTO = null;
        this.arguments = null;
        this.cacheWrapper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader loadData() throws Throwable {
        ProcessingTO processing = this.cacheHandler.processing.get(this.cacheKey);
        if (null == processing) {
            ProcessingTO newProcessing = new ProcessingTO();
            ProcessingTO firstProcessing = this.cacheHandler.processing.putIfAbsent(this.cacheKey, newProcessing);
            if (null == firstProcessing) {
                this.isFirst = true;
                processing = newProcessing;
            } else {
                this.isFirst = false;
                processing = firstProcessing;
            }
        } else {
            this.isFirst = false;
        }
        ProcessingTO lock = processing;
        String threadName = Thread.currentThread().getName();
        if (this.isFirst) {
            if (log.isTraceEnabled()) {
                log.trace("{} first thread!", (Object)threadName);
            }
            try {
                this.doFirstRequest(processing);
            }
            catch (Throwable e) {
                processing.setError(e);
                throw e;
            }
            finally {
                processing.setFirstFinished(true);
                this.cacheHandler.processing.remove(this.cacheKey);
                ProcessingTO processingTO = lock;
                synchronized (processingTO) {
                    lock.notifyAll();
                }
            }
        }
        this.doWaitRequest(processing, lock);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFirstRequest(ProcessingTO processingTO) throws Throwable {
        ILock distributedLock = this.cacheHandler.getLock();
        Throwable throwable = null;
        try {
            if (null != distributedLock && this.cache.lockExpire() > 0) {
                String lockKey = this.cacheKey.getLockKey();
                long startWait = processingTO.getStartTime();
                block5: do {
                    if (distributedLock.tryLock(lockKey, this.cache.lockExpire())) {
                        try {
                            this.getData();
                            break;
                        }
                        finally {
                            distributedLock.unlock(lockKey);
                        }
                    }
                    int tryCnt = 20;
                    for (int i = 0; i < tryCnt; ++i) {
                        this.cacheWrapper = this.cacheHandler.get(this.cacheKey, this.methodInfo);
                        if (null != this.cacheWrapper) continue block5;
                        Thread.sleep(10L);
                    }
                } while (null == this.cacheWrapper && System.currentTimeMillis() - startWait < (long)this.cache.waitTimeOut());
                if (null == this.cacheWrapper) {
                    throw new LoadDataTimeOutException("load data for key \"" + this.cacheKey.getCacheKey() + "\" timeout(" + this.cache.waitTimeOut() + " ms).");
                }
            }
        }
        catch (Throwable e) {
            if (this.cache.openLockDown()) {
                throwable = e;
                this.cacheHandler.setLock(null);
                log.error("\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u5f3a\u5236\u505c\u6b62\u4f7f\u7528\u5206\u5e03\u5f0f\u9501!", throwable);
            }
            log.error("\u5206\u5e03\u5f0f\u9501\u5f02\u5e38!", e);
            throw e;
        }
        if (throwable != null) {
            this.getData();
        }
        processingTO.setCache(this.cacheWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWaitRequest(ProcessingTO processing, Object lock) throws Throwable {
        long startWait = processing.getStartTime();
        String tname = Thread.currentThread().getName();
        do {
            Object tmpcacheWrapper;
            if (processing.isFirstFinished()) {
                tmpcacheWrapper = processing.getCache();
                if (log.isTraceEnabled()) {
                    log.trace("{} do FirstFinished is null :{}", (Object)tname, (Object)(null == tmpcacheWrapper ? 1 : 0));
                }
                if (null != tmpcacheWrapper) {
                    this.cacheWrapper = tmpcacheWrapper;
                    return;
                }
                Throwable error = processing.getError();
                if (null == error) break;
                if (log.isTraceEnabled()) {
                    log.trace("{} do error", (Object)tname);
                }
                throw error;
            }
            tmpcacheWrapper = lock;
            synchronized (tmpcacheWrapper) {
                if (log.isTraceEnabled()) {
                    log.trace("{} do wait", (Object)tname);
                }
                try {
                    lock.wait(2L);
                }
                catch (InterruptedException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        } while (System.currentTimeMillis() - startWait < (long)this.cache.waitTimeOut());
        if (null == this.cacheWrapper) {
            this.cacheWrapper = this.cacheHandler.get(this.cacheKey, this.methodInfo);
        }
        if (null == this.cacheWrapper) {
            AutoLoadConfig config = this.cacheHandler.getAutoLoadConfig();
            if (this.tryCnt < config.getLoadDataTryCnt()) {
                ++this.tryCnt;
                this.loadData();
            } else {
                throw new LoadDataTimeOutException("cache for key \"" + this.cacheKey.getCacheKey() + "\" loaded " + this.tryCnt + " times.");
            }
        }
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public DataLoader getData() throws Throwable {
        try {
            if (null != this.autoLoadTO) {
                this.autoLoadTO.setLoading(true);
            }
            long loadDataStartTime = System.currentTimeMillis();
            Object result = this.pjp.doProxyChain(this.arguments);
            this.loadDataUseTime = System.currentTimeMillis() - loadDataStartTime;
            AutoLoadConfig config = this.cacheHandler.getAutoLoadConfig();
            String className = this.pjp.getMethod().getDeclaringClass().getName();
            if (config.isPrintSlowLog() && this.loadDataUseTime >= (long)config.getSlowLoadTime()) {
                log.warn("{}.{}, use time:{}ms", new Object[]{className, this.pjp.getMethod().getName(), this.loadDataUseTime});
            }
            if (log.isDebugEnabled()) {
                log.debug("{}.{}, result is null : {}", new Object[]{className, this.pjp.getMethod().getName(), null == result});
            }
            this.buildCacheWrapper(result);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (null != this.autoLoadTO) {
                this.autoLoadTO.setLoading(false);
            }
        }
        return this;
    }

    private void buildCacheWrapper(Object result) {
        int expire = this.cache.expire();
        try {
            expire = this.cacheHandler.getScriptParser().getRealExpire(this.cache.expire(), this.cache.expireExpression(), this.arguments, result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.cacheWrapper = new CacheWrapper(result, expire);
    }

    public CacheWrapper<Object> getCacheWrapper() {
        if (null == this.cacheWrapper) {
            throw new RuntimeException("run loadData() or buildCacheWrapper() please!");
        }
        return this.cacheWrapper;
    }

    public long getLoadDataUseTime() {
        return this.loadDataUseTime;
    }
}

