/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.map;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.map.CacheChangeListener;
import com.jarvis.cache.map.CacheTask;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCacheManager
implements ICacheManager {
    private static final Logger logger = LoggerFactory.getLogger(MapCacheManager.class);
    private final ConcurrentHashMap<String, Object> cache;
    private final CacheChangeListener changeListener;
    private final ICloner cloner;
    private final AutoLoadConfig config;
    private int unpersistMaxSize = 0;
    private Thread thread = null;
    private CacheTask cacheTask = null;
    private String persistFile;
    private boolean needPersist = true;
    private boolean copyValueOnGet = false;
    private boolean copyValueOnSet = false;
    private int clearAndPersistPeriod = 60000;

    public MapCacheManager(AutoLoadConfig config, ICloner cloner) {
        this(config, cloner, 1024);
    }

    public MapCacheManager(AutoLoadConfig config, ICloner cloner, int initSize) {
        this.cache = new ConcurrentHashMap(initSize);
        this.config = config;
        this.config.setCheckFromCacheBeforeLoad(false);
        this.cloner = cloner;
        this.cacheTask = new CacheTask(this);
        this.changeListener = this.cacheTask;
    }

    public synchronized void start() {
        if (null == this.thread) {
            this.thread = new Thread(this.cacheTask);
            this.cacheTask.start();
            this.thread.start();
        }
    }

    public synchronized void destroy() {
        this.cacheTask.destroy();
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return;
        }
        if (result.getExpire() < 0) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return;
        }
        CacheWrapper value = null;
        if (this.copyValueOnSet) {
            try {
                value = (CacheWrapper)this.cloner.deepClone(result, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            value = result;
        }
        SoftReference<CacheWrapper<Object>> reference = new SoftReference<CacheWrapper<Object>>(value);
        String hfield = cacheKeyTO.getHfield();
        if (null == hfield || hfield.isEmpty()) {
            this.cache.put(cacheKey, reference);
        } else {
            ConcurrentHashMap hash;
            Object tmpObj = this.cache.get(cacheKey);
            if (null == tmpObj) {
                hash = new ConcurrentHashMap(16);
                ConcurrentHashMap tempHash = null;
                tempHash = (ConcurrentHashMap)this.cache.putIfAbsent(cacheKey, hash);
                if (null != tempHash) {
                    hash = tempHash;
                }
            } else if (tmpObj instanceof ConcurrentHashMap) {
                hash = (ConcurrentHashMap)tmpObj;
            } else {
                logger.error("key\u4e3a" + cacheKey + "\u7684\u7f13\u5b58\uff0c\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u5220\u9664\u7f13\u5b58\u518d\u8bd5\u3002");
                return;
            }
            hash.put(hfield, reference);
        }
        this.changeListener.cacheChange();
    }

    public void mset(Method method, Collection<MSetParam> params) throws CacheCenterConnectionException {
        if (null == params || params.isEmpty()) {
            return;
        }
        for (MSetParam param : params) {
            if (null == param) continue;
            this.setCache(param.getCacheKey(), (CacheWrapper<Object>)param.getResult(), method);
        }
    }

    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return null;
        }
        Object obj = this.cache.get(cacheKey);
        if (null == obj) {
            return null;
        }
        String hfield = cacheKeyTO.getHfield();
        CacheWrapper value = null;
        if (null == hfield || hfield.isEmpty()) {
            if (obj instanceof SoftReference) {
                SoftReference reference = (SoftReference)obj;
                if (null != reference) {
                    value = (CacheWrapper)reference.get();
                }
            } else if (obj instanceof CacheWrapper) {
                value = (CacheWrapper)obj;
            }
        } else {
            ConcurrentHashMap hash = (ConcurrentHashMap)obj;
            Object tmp = hash.get(hfield);
            if (tmp instanceof SoftReference) {
                SoftReference reference = (SoftReference)tmp;
                if (null != reference) {
                    value = (CacheWrapper)reference.get();
                }
            } else if (tmp instanceof CacheWrapper) {
                value = (CacheWrapper)tmp;
            }
        }
        if (null != value) {
            if (value.isExpired()) {
                return null;
            }
            if (this.copyValueOnGet) {
                try {
                    CacheWrapper res = (CacheWrapper)value.clone();
                    res.setCacheObject(this.cloner.deepClone(value.getCacheObject(), method.getReturnType()));
                    return res;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public Map<CacheKeyTO, CacheWrapper<Object>> mget(Method method, Type returnType, Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == keys || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        int len = keys.size();
        HashMap<CacheKeyTO, CacheWrapper<Object>> res = new HashMap<CacheKeyTO, CacheWrapper<Object>>(len);
        for (CacheKeyTO key : keys) {
            CacheWrapper<Object> value = this.get(key, method);
            if (null == value) continue;
            res.put(key, value);
        }
        return res;
    }

    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == keys || keys.isEmpty()) {
            return;
        }
        for (CacheKeyTO cacheKeyTO : keys) {
            ConcurrentHashMap hash;
            Object tmp;
            String cacheKey;
            if (null == cacheKeyTO || null == (cacheKey = cacheKeyTO.getCacheKey()) || cacheKey.isEmpty()) continue;
            String hfield = cacheKeyTO.getHfield();
            if (null == hfield || hfield.isEmpty()) {
                tmp = this.cache.remove(cacheKey);
                if (null == tmp) continue;
                if (tmp instanceof CacheWrapper) {
                    this.changeListener.cacheChange();
                    continue;
                }
                if (!(tmp instanceof ConcurrentHashMap) || (hash = (ConcurrentHashMap)tmp).size() <= 0) continue;
                this.changeListener.cacheChange(hash.size());
                continue;
            }
            hash = (ConcurrentHashMap)this.cache.get(cacheKey);
            if (null == hash || null == (tmp = hash.remove(hfield))) continue;
            this.changeListener.cacheChange();
        }
    }

    public ConcurrentHashMap<String, Object> getCache() {
        return this.cache;
    }

    public String getPersistFile() {
        return this.persistFile;
    }

    public void setPersistFile(String persistFile) {
        this.persistFile = persistFile;
    }

    public boolean isNeedPersist() {
        return this.needPersist;
    }

    public void setNeedPersist(boolean needPersist) {
        this.needPersist = needPersist;
    }

    public int getUnpersistMaxSize() {
        return this.unpersistMaxSize;
    }

    public void setUnpersistMaxSize(int unpersistMaxSize) {
        if (unpersistMaxSize > 0) {
            this.unpersistMaxSize = unpersistMaxSize;
        }
    }

    public boolean isCopyValueOnGet() {
        return this.copyValueOnGet;
    }

    public void setCopyValueOnGet(boolean copyValueOnGet) {
        this.copyValueOnGet = copyValueOnGet;
    }

    public boolean isCopyValueOnSet() {
        return this.copyValueOnSet;
    }

    public void setCopyValueOnSet(boolean copyValueOnSet) {
        this.copyValueOnSet = copyValueOnSet;
    }

    public int getClearAndPersistPeriod() {
        return this.clearAndPersistPeriod;
    }

    public void setClearAndPersistPeriod(int clearAndPersistPeriod) {
        this.clearAndPersistPeriod = clearAndPersistPeriod;
    }

    public AutoLoadConfig getAutoLoadConfig() {
        return this.config;
    }
}

