/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer.protobuf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import com.jarvis.cache.reflect.lambda.Lambda;
import com.jarvis.cache.reflect.lambda.LambdaFactory;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.protobuf.ByteBufOutputStream;
import com.jarvis.cache.serializer.protobuf.CacheObjectFactory;
import com.jarvis.cache.serializer.protobuf.ReadByteBuf;
import com.jarvis.cache.serializer.protobuf.WriteByteBuf;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.lib.util.BeanUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufSerializer
implements ISerializer<CacheWrapper<Object>> {
    private static final Logger log = LoggerFactory.getLogger(ProtoBufSerializer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private ConcurrentHashMap<Class, Lambda> lambdaMap = new ConcurrentHashMap(64);
    private ObjectPool<WriteByteBuf> writePool;
    private ObjectPool<ReadByteBuf> readPool;

    public ProtoBufSerializer() {
        this.init();
    }

    private void init() {
        this.writePool = new GenericObjectPool((PooledObjectFactory)CacheObjectFactory.createWriteByteBuf());
        this.readPool = new GenericObjectPool((PooledObjectFactory)CacheObjectFactory.createReadByteBuf());
    }

    public byte[] serialize(CacheWrapper<Object> obj) throws Exception {
        WriteByteBuf byteBuf = (WriteByteBuf)this.writePool.borrowObject();
        byteBuf.resetIndex();
        byteBuf.writeInt(obj.getExpire());
        byteBuf.writeLong(obj.getLastLoadTime());
        Object cacheObj = obj.getCacheObject();
        if (cacheObj instanceof Message) {
            Message message = (Message)cacheObj;
            message.writeTo((OutputStream)new ByteBufOutputStream(byteBuf));
        } else if (cacheObj != null) {
            byteBuf.writeBytes(MAPPER.writeValueAsBytes(cacheObj));
        }
        byte[] bytes = byteBuf.readableBytes();
        this.writePool.returnObject((Object)byteBuf);
        return bytes;
    }

    public CacheWrapper<Object> deserialize(byte[] bytes, Type returnType) throws Exception {
        Class clazz;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        CacheWrapper cacheWrapper = new CacheWrapper();
        ReadByteBuf byteBuf = (ReadByteBuf)this.readPool.borrowObject();
        byteBuf.setBytes(bytes);
        cacheWrapper.setExpire(byteBuf.readInt());
        cacheWrapper.setLastLoadTime(byteBuf.readLong());
        bytes = byteBuf.readableBytes();
        this.readPool.returnObject((Object)byteBuf);
        if (bytes == null || bytes.length == 0) {
            return cacheWrapper;
        }
        String typeName = null;
        if (!(returnType instanceof ParameterizedType)) {
            typeName = returnType.getTypeName();
        }
        if (null != (clazz = this.getMessageClass(typeName)) && Message.class.isAssignableFrom(clazz)) {
            Lambda lambda = this.getLambda(clazz);
            Object obj = lambda.invoke_for_Object((Object)new ByteArrayInputStream(bytes));
            cacheWrapper.setCacheObject(obj);
        } else {
            cacheWrapper.setCacheObject(MAPPER.readValue(bytes, MAPPER.constructType(returnType)));
        }
        return cacheWrapper;
    }

    private Class getMessageClass(String typeName) throws ClassNotFoundException {
        if (null == typeName) {
            return null;
        }
        return Class.forName(typeName);
    }

    public Object deepClone(Object obj, Type type) throws Exception {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (BeanUtil.isPrimitive((Object)obj) || clazz.isEnum() || obj instanceof Class || clazz.isAnnotation() || clazz.isSynthetic()) {
            return obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof Calendar) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Calendar)obj).getTime().getTime());
            return cal;
        }
        if (clazz.isArray()) {
            Object[] arr = (Object[])obj;
            Object[] res = clazz == Object[].class ? new Object[arr.length] : (Object[])Array.newInstance(clazz.getComponentType(), arr.length);
            for (int i = 0; i < arr.length; ++i) {
                res[i] = this.deepClone(arr[i], null);
            }
            return res;
        }
        if (obj instanceof Collection) {
            Collection tempCol = (Collection)obj;
            Collection res = (Collection)tempCol.getClass().newInstance();
            Iterator it = tempCol.iterator();
            while (it.hasNext()) {
                Object val = this.deepClone(it.next(), null);
                res.add(val);
            }
            return res;
        }
        if (obj instanceof Map) {
            Map tempMap = (Map)obj;
            Map res = (Map)tempMap.getClass().newInstance();
            for (Map.Entry entry : tempMap.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                res.put(this.deepClone(key, null), this.deepClone(val, null));
            }
            return res;
        }
        if (obj instanceof CacheWrapper) {
            CacheWrapper wrapper = (CacheWrapper)obj;
            CacheWrapper res = new CacheWrapper();
            res.setExpire(wrapper.getExpire());
            res.setLastLoadTime(wrapper.getLastLoadTime());
            res.setCacheObject(this.deepClone(wrapper.getCacheObject(), null));
            return res;
        }
        if (obj instanceof Message) {
            return ((Message)obj).toBuilder().build();
        }
        return ObjectUtils.clone((Object)obj);
    }

    public Object[] deepCloneMethodArgs(Method method, Object[] args) throws Exception {
        if (null == args || args.length == 0) {
            return args;
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (args.length != genericParameterTypes.length) {
            throw new Exception("the length of " + method.getDeclaringClass().getName() + "." + method.getName() + " must " + genericParameterTypes.length);
        }
        Object[] res = new Object[args.length];
        int len = genericParameterTypes.length;
        for (int i = 0; i < len; ++i) {
            res[i] = this.deepClone(args[i], null);
        }
        return res;
    }

    private Lambda getLambda(Class clazz) throws NoSuchMethodException {
        Lambda lambda = this.lambdaMap.get(clazz);
        if (lambda == null) {
            Method method = clazz.getDeclaredMethod("parseFrom", InputStream.class);
            try {
                lambda = LambdaFactory.create((Method)method);
                this.lambdaMap.put(clazz, lambda);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return lambda;
    }
}

