/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer.protobuf;

import com.jarvis.cache.serializer.protobuf.HeapByteBufUtil;

public class ReadByteBuf {
    private byte[] array;
    private int readerIndex;

    public ReadByteBuf setBytes(byte[] bytes) {
        this.array = bytes;
        this.readerIndex = 0;
        return this;
    }

    public byte readByte() {
        byte value = HeapByteBufUtil.getByte(this.array, this.readerIndex);
        ++this.readerIndex;
        return value;
    }

    public int readInt() {
        int value = HeapByteBufUtil.getInt(this.array, this.readerIndex);
        this.readerIndex += 4;
        return value;
    }

    public long readLong() {
        long value = HeapByteBufUtil.getLong(this.array, this.readerIndex);
        this.readerIndex += 8;
        return value;
    }

    public byte[] readableBytes() {
        byte[] newArray = new byte[this.array.length - this.readerIndex];
        System.arraycopy(this.array, this.readerIndex, newArray, 0, newArray.length);
        return newArray;
    }
}

