/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer.protobuf;

import com.jarvis.cache.serializer.protobuf.HeapByteBufUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteByteBuf {
    private static final Logger log = LoggerFactory.getLogger(WriteByteBuf.class);
    private static final int DEFAULT_ARRAY_LENGTH = 102400;
    private byte[] array;
    private int readerIndex;
    private int writerIndex;
    private int limit;
    private int arrayLength;

    public WriteByteBuf() {
        this(102400);
    }

    public WriteByteBuf(int arrayLength) {
        this.array = new byte[arrayLength];
        this.writerIndex = 0;
        this.readerIndex = 0;
        this.arrayLength = arrayLength;
    }

    public void writeByte(byte value) {
        int length = 1;
        this.hasLength(length);
        HeapByteBufUtil.setByte(this.array, this.writerIndex, value);
        this.writerIndex += length;
        this.limit = this.writerIndex;
    }

    public void writeInt(int value) {
        int length = 4;
        this.hasLength(length);
        HeapByteBufUtil.setInt(this.array, this.writerIndex, value);
        this.writerIndex += length;
        this.limit = this.writerIndex;
    }

    public void writeLong(long value) {
        int length = 8;
        this.hasLength(length);
        HeapByteBufUtil.setLong(this.array, this.writerIndex, value);
        this.writerIndex += length;
        this.limit = this.writerIndex;
    }

    public byte[] readableBytes() {
        byte[] newArray = new byte[this.limit - this.readerIndex];
        System.arraycopy(this.array, this.readerIndex, newArray, 0, newArray.length);
        return newArray;
    }

    public void resetIndex() {
        this.limit = 0;
        this.readerIndex = 0;
        this.writerIndex = 0;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private void hasLength(int length) {
        if (this.limit + length < this.arrayLength) {
            return;
        }
        log.error("current byte stream length {} write length {}", (Object)this.limit, (Object)length);
        throw new ArrayIndexOutOfBoundsException();
    }

    public void writeBytes(byte[] bytes) {
        this.hasLength(bytes.length);
        System.arraycopy(bytes, 0, this.array, this.writerIndex, bytes.length);
        this.limit += bytes.length;
    }

    public void writeObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(outputStream);
            output.writeObject(obj);
            output.flush();
            this.writeBytes(outputStream.toByteArray());
        }
        catch (IOException e) {
            log.warn("byteBuf writeObject error");
        }
    }
}

