/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.filter;

import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.swagger2.web.SwaggerTransformationContext;
import springfox.documentation.swagger2.web.WebMvcSwaggerTransformationFilter;

public class Swagger2WebMvcSwaggerTransformationFilter
implements WebMvcSwaggerTransformationFilter {
    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_2.equals((Object)delimiter);
    }

    @Override
    public Swagger transform(SwaggerTransformationContext<HttpServletRequest> context) {
        Swagger swagger = context.getSpecification();
        Map definitions = swagger.getDefinitions();
        for (String key : definitions.keySet()) {
            Model model = (Model)definitions.get(key);
            if (model == null) continue;
            HashMap properties = model.getProperties();
            if (properties == null) {
                properties = new HashMap();
            }
            LinkedHashMap<String, Property> sortedProperties = new LinkedHashMap<String, Property>(properties.size());
            List fieldNameList = properties.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(Property::getPosition).thenComparing(Property::getName))).map(Map.Entry::getKey).collect(Collectors.toList());
            for (String fieldName : fieldNameList) {
                sortedProperties.put(fieldName, (Property)properties.get(fieldName));
            }
            if (model.getProperties() != null) {
                model.getProperties().clear();
            }
            model.setProperties(sortedProperties);
        }
        return swagger;
    }
}

