/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricConfig;
import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricStringEncryptor;
import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.Optional;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.Environment;

public class DefaultLazyEncryptor
implements StringEncryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyEncryptor.class);
    private final Singleton<StringEncryptor> singleton;

    public DefaultLazyEncryptor(Environment e, String customEncryptorBeanName, BeanFactory bf) {
        this.singleton = new Singleton<StringEncryptor>(() -> Optional.of(customEncryptorBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (StringEncryptor)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Encryptor Bean {} with name: {}", bean, (Object)customEncryptorBeanName))).orElseGet(() -> {
            log.info("String Encryptor custom Bean not found with name '{}'. Initializing Default String Encryptor", (Object)customEncryptorBeanName);
            return this.createDefault(e);
        }));
    }

    public DefaultLazyEncryptor(Environment e) {
        this.singleton = new Singleton<StringEncryptor>(() -> this.createDefault(e));
    }

    private StringEncryptor createDefault(Environment e) {
        return Optional.of(e).filter(DefaultLazyEncryptor::isPBEConfig).map(this::createPBEDefault).orElseGet(() -> Optional.of(e).filter(DefaultLazyEncryptor::isAsymmetricConfig).map(this::createAsymmetricDefault).orElseThrow(() -> new IllegalStateException("either 'jasypt.encryptor.password' or one of ['jasypt.encryptor.privateKeyString', 'jasypt.encryptor.privateKeyLocation'] must be provided for Password-based or Asymmetric encryption")));
    }

    private StringEncryptor createAsymmetricDefault(Environment e) {
        SimpleAsymmetricConfig config = new SimpleAsymmetricConfig();
        config.setPrivateKey(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.privateKeyString", null));
        config.setPrivateKeyLocation(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.privateKeyLocation", null));
        config.setPrivateKeyFormat(AsymmetricCryptography.KeyFormat.valueOf(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.privateKeyFormat", "DER")));
        return new SimpleAsymmetricStringEncryptor(config);
    }

    private StringEncryptor createPBEDefault(Environment e) {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(DefaultLazyEncryptor.getRequiredProperty(e, "jasypt.encryptor.password"));
        config.setAlgorithm(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.algorithm", "PBEWithMD5AndDES"));
        config.setKeyObtentionIterations(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.keyObtentionIterations", "1000"));
        config.setPoolSize(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.poolSize", "1"));
        config.setProviderName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.providerName", null));
        config.setProviderClassName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.providerClassName", null));
        config.setSaltGeneratorClassName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.saltGeneratorClassname", "org.jasypt.salt.RandomSaltGenerator"));
        config.setIvGeneratorClassName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.ivGeneratorClassname", "org.jasypt.salt.NoOpIVGenerator"));
        config.setStringOutputType(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.stringOutputType", "base64"));
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    private static boolean isAsymmetricConfig(Environment e) {
        return DefaultLazyEncryptor.propertyExists(e, "jasypt.encryptor.privateKeyString") || DefaultLazyEncryptor.propertyExists(e, "jasypt.encryptor.privateKeyLocation");
    }

    private static boolean isPBEConfig(Environment e) {
        return DefaultLazyEncryptor.propertyExists(e, "jasypt.encryptor.password");
    }

    private static String getProperty(Environment environment, String key, String defaultValue) {
        if (!DefaultLazyEncryptor.propertyExists(environment, key)) {
            log.info("Encryptor config not found for property {}, using default value: {}", (Object)key, (Object)defaultValue);
        }
        return environment.getProperty(key, defaultValue);
    }

    private static boolean propertyExists(Environment environment, String key) {
        return environment.getProperty(key) != null;
    }

    private static String getRequiredProperty(Environment environment, String key) {
        if (!DefaultLazyEncryptor.propertyExists(environment, key)) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return environment.getProperty(key);
    }

    public String encrypt(String message) {
        return this.singleton.get().encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        return this.singleton.get().decrypt(encryptedMessage);
    }
}

