/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SimpleAsymmetricConfig {
    private String privateKey = null;
    private String publicKey = null;
    private String privateKeyLocation = null;
    private String publicKeyLocation = null;
    private Resource privateKeyResource = null;
    private Resource publicKeyResource = null;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private AsymmetricCryptography.KeyFormat privateKeyFormat = AsymmetricCryptography.KeyFormat.DER;
    private AsymmetricCryptography.KeyFormat publicKeyFormat = AsymmetricCryptography.KeyFormat.DER;

    private Resource loadResource(Resource asResource, String asString, String asLocation, AsymmetricCryptography.KeyFormat format) {
        return Optional.ofNullable(asResource).orElseGet(() -> Optional.ofNullable(asString).map(pk -> new ByteArrayResource(format == AsymmetricCryptography.KeyFormat.DER ? Base64.getDecoder().decode((String)pk) : pk.getBytes(StandardCharsets.UTF_8))).orElseGet(() -> Optional.ofNullable(asLocation).map(arg_0 -> ((ResourceLoader)this.resourceLoader).getResource(arg_0)).orElseThrow(() -> new IllegalArgumentException("Unable to load key. Either resource, key as string, or resource location must be provided"))));
    }

    public Resource loadPrivateKeyResource() {
        return this.loadResource(this.privateKeyResource, this.privateKey, this.privateKeyLocation, this.privateKeyFormat);
    }

    public Resource loadPublicKeyResource() {
        return this.loadResource(this.publicKeyResource, this.publicKey, this.publicKeyLocation, this.publicKeyFormat);
    }

    public void setKeyFormat(AsymmetricCryptography.KeyFormat keyFormat) {
        this.setPublicKeyFormat(keyFormat);
        this.setPrivateKeyFormat(keyFormat);
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKeyLocation() {
        return this.privateKeyLocation;
    }

    public String getPublicKeyLocation() {
        return this.publicKeyLocation;
    }

    public Resource getPrivateKeyResource() {
        return this.privateKeyResource;
    }

    public Resource getPublicKeyResource() {
        return this.publicKeyResource;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public AsymmetricCryptography.KeyFormat getPrivateKeyFormat() {
        return this.privateKeyFormat;
    }

    public AsymmetricCryptography.KeyFormat getPublicKeyFormat() {
        return this.publicKeyFormat;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKeyLocation(String privateKeyLocation) {
        this.privateKeyLocation = privateKeyLocation;
    }

    public void setPublicKeyLocation(String publicKeyLocation) {
        this.publicKeyLocation = publicKeyLocation;
    }

    public void setPrivateKeyResource(Resource privateKeyResource) {
        this.privateKeyResource = privateKeyResource;
    }

    public void setPublicKeyResource(Resource publicKeyResource) {
        this.publicKeyResource = publicKeyResource;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setPrivateKeyFormat(AsymmetricCryptography.KeyFormat privateKeyFormat) {
        this.privateKeyFormat = privateKeyFormat;
    }

    public void setPublicKeyFormat(AsymmetricCryptography.KeyFormat publicKeyFormat) {
        this.publicKeyFormat = publicKeyFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleAsymmetricConfig)) {
            return false;
        }
        SimpleAsymmetricConfig other = (SimpleAsymmetricConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$privateKeyLocation = this.getPrivateKeyLocation();
        String other$privateKeyLocation = other.getPrivateKeyLocation();
        if (this$privateKeyLocation == null ? other$privateKeyLocation != null : !this$privateKeyLocation.equals(other$privateKeyLocation)) {
            return false;
        }
        String this$publicKeyLocation = this.getPublicKeyLocation();
        String other$publicKeyLocation = other.getPublicKeyLocation();
        if (this$publicKeyLocation == null ? other$publicKeyLocation != null : !this$publicKeyLocation.equals(other$publicKeyLocation)) {
            return false;
        }
        Resource this$privateKeyResource = this.getPrivateKeyResource();
        Resource other$privateKeyResource = other.getPrivateKeyResource();
        if (this$privateKeyResource == null ? other$privateKeyResource != null : !this$privateKeyResource.equals(other$privateKeyResource)) {
            return false;
        }
        Resource this$publicKeyResource = this.getPublicKeyResource();
        Resource other$publicKeyResource = other.getPublicKeyResource();
        if (this$publicKeyResource == null ? other$publicKeyResource != null : !this$publicKeyResource.equals(other$publicKeyResource)) {
            return false;
        }
        ResourceLoader this$resourceLoader = this.getResourceLoader();
        ResourceLoader other$resourceLoader = other.getResourceLoader();
        if (this$resourceLoader == null ? other$resourceLoader != null : !this$resourceLoader.equals(other$resourceLoader)) {
            return false;
        }
        AsymmetricCryptography.KeyFormat this$privateKeyFormat = this.getPrivateKeyFormat();
        AsymmetricCryptography.KeyFormat other$privateKeyFormat = other.getPrivateKeyFormat();
        if (this$privateKeyFormat == null ? other$privateKeyFormat != null : !((Object)((Object)this$privateKeyFormat)).equals((Object)other$privateKeyFormat)) {
            return false;
        }
        AsymmetricCryptography.KeyFormat this$publicKeyFormat = this.getPublicKeyFormat();
        AsymmetricCryptography.KeyFormat other$publicKeyFormat = other.getPublicKeyFormat();
        return !(this$publicKeyFormat == null ? other$publicKeyFormat != null : !((Object)((Object)this$publicKeyFormat)).equals((Object)other$publicKeyFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleAsymmetricConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $privateKeyLocation = this.getPrivateKeyLocation();
        result = result * 59 + ($privateKeyLocation == null ? 43 : $privateKeyLocation.hashCode());
        String $publicKeyLocation = this.getPublicKeyLocation();
        result = result * 59 + ($publicKeyLocation == null ? 43 : $publicKeyLocation.hashCode());
        Resource $privateKeyResource = this.getPrivateKeyResource();
        result = result * 59 + ($privateKeyResource == null ? 43 : $privateKeyResource.hashCode());
        Resource $publicKeyResource = this.getPublicKeyResource();
        result = result * 59 + ($publicKeyResource == null ? 43 : $publicKeyResource.hashCode());
        ResourceLoader $resourceLoader = this.getResourceLoader();
        result = result * 59 + ($resourceLoader == null ? 43 : $resourceLoader.hashCode());
        AsymmetricCryptography.KeyFormat $privateKeyFormat = this.getPrivateKeyFormat();
        result = result * 59 + ($privateKeyFormat == null ? 43 : ((Object)((Object)$privateKeyFormat)).hashCode());
        AsymmetricCryptography.KeyFormat $publicKeyFormat = this.getPublicKeyFormat();
        result = result * 59 + ($publicKeyFormat == null ? 43 : ((Object)((Object)$publicKeyFormat)).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleAsymmetricConfig(privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ", privateKeyLocation=" + this.getPrivateKeyLocation() + ", publicKeyLocation=" + this.getPublicKeyLocation() + ", privateKeyResource=" + this.getPrivateKeyResource() + ", publicKeyResource=" + this.getPublicKeyResource() + ", resourceLoader=" + this.getResourceLoader() + ", privateKeyFormat=" + (Object)((Object)this.getPrivateKeyFormat()) + ", publicKeyFormat=" + (Object)((Object)this.getPublicKeyFormat()) + ")";
    }
}

