/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableLongObjectMap;
import com.gs.collections.api.map.primitive.LongObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableLongObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongObjectMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <V> ImmutableLongObjectMap<V> of();

    <V> ImmutableLongObjectMap<V> with();

    /**
     * Same as {@link #with(long, Object)}.
     */
    <V> ImmutableLongObjectMap<V> of(long key, V value);

    <V> ImmutableLongObjectMap<V> with(long key, V value);

    /**
     * Same as {@link #withAll(LongObjectMap)}.
     */
    <V> ImmutableLongObjectMap<V> ofAll(LongObjectMap<? extends V>  map);

    <V> ImmutableLongObjectMap<V> withAll(LongObjectMap<? extends V>  map);
}
