/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import java.util.List;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.ordered.primitive.ReversibleLongIterable;

/**
 * This file was automatically generated from template file primitiveList.stg.
 *
 * @since 3.0.
 */
public interface LongList extends ReversibleLongIterable
{
    long get(int index);

    long dotProduct(LongList list);

    int lastIndexOf(long value);

    LongList select(LongPredicate predicate);

    LongList reject(LongPredicate predicate);

    <V> ListIterable<V> collect(LongToObjectFunction<? extends V> function);

    /**
     * Follows the same general contract as {@link List#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link List#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns an immutable copy of this list. If the list is immutable, it returns itself.
     */
    ImmutableLongList toImmutable();

    /**
     * @since 5.0.
     */
    LongList toReversed();

    /**
     * @see {@link List#subList(int fromIndex, int toIndex)}
     * @since 5.0.
     */
    LongList subList(int fromIndex, int toIndex);
}
