/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableLongList extends MutableLongCollection, LongList
{
    void addAtIndex(int index, long element);

    boolean addAllAtIndex(int index, long... source);

    boolean addAllAtIndex(int index, LongIterable source);

    long removeAtIndex(int index);

    long set(int index, long element);

    MutableLongList select(LongPredicate predicate);

    MutableLongList reject(LongPredicate predicate);

    MutableLongList with(long element);

    MutableLongList without(long element);

    MutableLongList withAll(LongIterable elements);

    MutableLongList withoutAll(LongIterable elements);

    <V> MutableList<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongList reverseThis();

    MutableLongList toReversed();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableLongList sortThis();

    MutableLongList asUnmodifiable();

    MutableLongList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableLongList toImmutable();

    MutableLongList subList(int fromIndex, int toIndex);
}
