/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableFloatFloatMap extends FloatFloatMap
{
    ImmutableFloatFloatMap select(FloatFloatPredicate predicate);

    ImmutableFloatFloatMap reject(FloatFloatPredicate predicate);

    ImmutableFloatCollection select(FloatPredicate predicate);

    ImmutableFloatCollection reject(FloatPredicate predicate);

    <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    ImmutableFloatFloatMap newWithKeyValue(float key, float value);

    ImmutableFloatFloatMap newWithoutKey(float key);

    ImmutableFloatFloatMap newWithoutAllKeys(FloatIterable keys);
}
