/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;

/**
 * This file was automatically generated from template file immutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableObjectBooleanMap<K> extends ObjectBooleanMap<K>
{
    ImmutableObjectBooleanMap<K> select(ObjectBooleanPredicate<? super K> predicate);

    ImmutableObjectBooleanMap<K> reject(ObjectBooleanPredicate<? super K> predicate);

    ImmutableBooleanCollection select(BooleanPredicate predicate);

    ImmutableBooleanCollection reject(BooleanPredicate predicate);

    <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableObjectBooleanMap<K> newWithKeyValue(K key, boolean value);

    ImmutableObjectBooleanMap<K> newWithoutKey(K key);

    ImmutableObjectBooleanMap<K> newWithoutAllKeys(Iterable<? extends K> keys);
}
