/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.function.primitive.ByteToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.ByteIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteIntMap extends ByteIntMap
{
    void clear();

    void put(byte key, int value);

    void putAll(ByteIntMap map);

    void removeKey(byte key);

    void remove(byte key);

    int removeKeyIfAbsent(byte key, int value);

    int getIfAbsentPut(byte key, int value);

    int getIfAbsentPut(byte key, IntFunction0 function);

    int getIfAbsentPutWithKey(byte key, ByteToIntFunction function);

    <P> int getIfAbsentPutWith(byte key, IntFunction<? super P> function, P parameter);

    int updateValue(byte key, int initialValueIfAbsent, IntToIntFunction function);

    MutableByteIntMap select(ByteIntPredicate predicate);

    MutableByteIntMap reject(ByteIntPredicate predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableByteIntMap withKeyValue(byte key, int value);

    MutableByteIntMap withoutKey(byte key);

    MutableByteIntMap withoutAllKeys(ByteIterable keys);

    MutableByteIntMap asUnmodifiable();

    MutableByteIntMap asSynchronized();

    int addToValue(byte key, int toBeAdded);
}
