/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.function.primitive.FloatToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.FloatBooleanPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatBooleanMap extends FloatBooleanMap
{
    void clear();

    void put(float key, boolean value);

    void putAll(FloatBooleanMap map);

    void removeKey(float key);

    void remove(float key);

    boolean removeKeyIfAbsent(float key, boolean value);

    boolean getIfAbsentPut(float key, boolean value);

    boolean getIfAbsentPut(float key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(float key, FloatToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(float key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(float key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableFloatBooleanMap select(FloatBooleanPredicate predicate);

    MutableFloatBooleanMap reject(FloatBooleanPredicate predicate);

    MutableBooleanCollection select(BooleanPredicate predicate);

    MutableBooleanCollection reject(BooleanPredicate predicate);

    <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableFloatBooleanMap withKeyValue(float key, boolean value);

    MutableFloatBooleanMap withoutKey(float key);

    MutableFloatBooleanMap withoutAllKeys(FloatIterable keys);

    MutableFloatBooleanMap asUnmodifiable();

    MutableFloatBooleanMap asSynchronized();

}
