/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.function.primitive.FloatToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.FloatIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatIntMap extends FloatIntMap
{
    void clear();

    void put(float key, int value);

    void putAll(FloatIntMap map);

    void removeKey(float key);

    void remove(float key);

    int removeKeyIfAbsent(float key, int value);

    int getIfAbsentPut(float key, int value);

    int getIfAbsentPut(float key, IntFunction0 function);

    int getIfAbsentPutWithKey(float key, FloatToIntFunction function);

    <P> int getIfAbsentPutWith(float key, IntFunction<? super P> function, P parameter);

    int updateValue(float key, int initialValueIfAbsent, IntToIntFunction function);

    MutableFloatIntMap select(FloatIntPredicate predicate);

    MutableFloatIntMap reject(FloatIntPredicate predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableFloatIntMap withKeyValue(float key, int value);

    MutableFloatIntMap withoutKey(float key);

    MutableFloatIntMap withoutAllKeys(FloatIterable keys);

    MutableFloatIntMap asUnmodifiable();

    MutableFloatIntMap asSynchronized();

    int addToValue(float key, int toBeAdded);
}
