/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.function.primitive.FloatToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.FloatShortPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatShortMap extends FloatShortMap
{
    void clear();

    void put(float key, short value);

    void putAll(FloatShortMap map);

    void removeKey(float key);

    void remove(float key);

    short removeKeyIfAbsent(float key, short value);

    short getIfAbsentPut(float key, short value);

    short getIfAbsentPut(float key, ShortFunction0 function);

    short getIfAbsentPutWithKey(float key, FloatToShortFunction function);

    <P> short getIfAbsentPutWith(float key, ShortFunction<? super P> function, P parameter);

    short updateValue(float key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableFloatShortMap select(FloatShortPredicate predicate);

    MutableFloatShortMap reject(FloatShortPredicate predicate);

    MutableShortCollection select(ShortPredicate predicate);

    MutableShortCollection reject(ShortPredicate predicate);

    <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    MutableFloatShortMap withKeyValue(float key, short value);

    MutableFloatShortMap withoutKey(float key);

    MutableFloatShortMap withoutAllKeys(FloatIterable keys);

    MutableFloatShortMap asUnmodifiable();

    MutableFloatShortMap asSynchronized();

    short addToValue(float key, short toBeAdded);
}
