/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.function.primitive.LongToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.LongIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongIntMap extends LongIntMap
{
    void clear();

    void put(long key, int value);

    void putAll(LongIntMap map);

    void removeKey(long key);

    void remove(long key);

    int removeKeyIfAbsent(long key, int value);

    int getIfAbsentPut(long key, int value);

    int getIfAbsentPut(long key, IntFunction0 function);

    int getIfAbsentPutWithKey(long key, LongToIntFunction function);

    <P> int getIfAbsentPutWith(long key, IntFunction<? super P> function, P parameter);

    int updateValue(long key, int initialValueIfAbsent, IntToIntFunction function);

    MutableLongIntMap select(LongIntPredicate predicate);

    MutableLongIntMap reject(LongIntPredicate predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableLongIntMap withKeyValue(long key, int value);

    MutableLongIntMap withoutKey(long key);

    MutableLongIntMap withoutAllKeys(LongIterable keys);

    MutableLongIntMap asUnmodifiable();

    MutableLongIntMap asSynchronized();

    int addToValue(long key, int toBeAdded);
}
