/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.ShortToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.ShortFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortFloatMap extends ShortFloatMap
{
    void clear();

    void put(short key, float value);

    void putAll(ShortFloatMap map);

    void removeKey(short key);

    void remove(short key);

    float removeKeyIfAbsent(short key, float value);

    float getIfAbsentPut(short key, float value);

    float getIfAbsentPut(short key, FloatFunction0 function);

    float getIfAbsentPutWithKey(short key, ShortToFloatFunction function);

    <P> float getIfAbsentPutWith(short key, FloatFunction<? super P> function, P parameter);

    float updateValue(short key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableShortFloatMap select(ShortFloatPredicate predicate);

    MutableShortFloatMap reject(ShortFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableShortFloatMap withKeyValue(short key, float value);

    MutableShortFloatMap withoutKey(short key);

    MutableShortFloatMap withoutAllKeys(ShortIterable keys);

    MutableShortFloatMap asUnmodifiable();

    MutableShortFloatMap asSynchronized();

    float addToValue(short key, float toBeAdded);
}
