/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableByteBooleanMap;
import com.gs.collections.api.map.primitive.ByteBooleanMap;

/**
 * A factory which creates instances of type {@link ImmutableByteBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableByteBooleanMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableByteBooleanMap of();

    ImmutableByteBooleanMap with();

    /**
     * Same as {@link #with(byte, boolean)}.
     */
    ImmutableByteBooleanMap of(byte key, boolean value);

    ImmutableByteBooleanMap with(byte key, boolean value);

    /**
     * Same as {@link #withAll(ByteBooleanMap)}.
     */
    ImmutableByteBooleanMap ofAll(ByteBooleanMap map);

    ImmutableByteBooleanMap withAll(ByteBooleanMap map);
}
