/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableLongBooleanMap;
import com.gs.collections.api.map.primitive.LongBooleanMap;

/**
 * A factory which creates instances of type {@link ImmutableLongBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongBooleanMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableLongBooleanMap of();

    ImmutableLongBooleanMap with();

    /**
     * Same as {@link #with(long, boolean)}.
     */
    ImmutableLongBooleanMap of(long key, boolean value);

    ImmutableLongBooleanMap with(long key, boolean value);

    /**
     * Same as {@link #withAll(LongBooleanMap)}.
     */
    ImmutableLongBooleanMap ofAll(LongBooleanMap map);

    ImmutableLongBooleanMap withAll(LongBooleanMap map);
}
