/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanList extends MutableBooleanCollection, BooleanList
{
    void addAtIndex(int index, boolean element);

    boolean addAllAtIndex(int index, boolean... source);

    boolean addAllAtIndex(int index, BooleanIterable source);

    boolean removeAtIndex(int index);

    boolean set(int index, boolean element);

    MutableBooleanList select(BooleanPredicate predicate);

    MutableBooleanList reject(BooleanPredicate predicate);

    MutableBooleanList with(boolean element);

    MutableBooleanList without(boolean element);

    MutableBooleanList withAll(BooleanIterable elements);

    MutableBooleanList withoutAll(BooleanIterable elements);

    <V> MutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanList reverseThis();

    MutableBooleanList toReversed();

    MutableBooleanList asUnmodifiable();

    MutableBooleanList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableBooleanList toImmutable();

    MutableBooleanList subList(int fromIndex, int toIndex);
}
