/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleList extends MutableDoubleCollection, DoubleList
{
    void addAtIndex(int index, double element);

    boolean addAllAtIndex(int index, double... source);

    boolean addAllAtIndex(int index, DoubleIterable source);

    double removeAtIndex(int index);

    double set(int index, double element);

    MutableDoubleList select(DoublePredicate predicate);

    MutableDoubleList reject(DoublePredicate predicate);

    MutableDoubleList with(double element);

    MutableDoubleList without(double element);

    MutableDoubleList withAll(DoubleIterable elements);

    MutableDoubleList withoutAll(DoubleIterable elements);

    <V> MutableList<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleList reverseThis();

    MutableDoubleList toReversed();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableDoubleList sortThis();

    MutableDoubleList asUnmodifiable();

    MutableDoubleList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableDoubleList toImmutable();

    MutableDoubleList subList(int fromIndex, int toIndex);
}
