/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.ByteObjectPredicate;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteObjectMap<V> extends ByteObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(byte key, V value);

    /**
     * @since 5.0.
     */
    void putAll(ByteObjectMap<? extends V> map);

    V removeKey(byte key);

    V remove(byte key);

    V getIfAbsentPut(byte key, V value);

    V getIfAbsentPut(byte key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(byte key, ByteToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(byte key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(byte key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(byte, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(byte key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableByteObjectMap<V> select(ByteObjectPredicate<? super V> predicate);

    MutableByteObjectMap<V> reject(ByteObjectPredicate<? super V> predicate);

    MutableCollection<V> select(Predicate<? super V> predicate);

    MutableCollection<V> reject(Predicate<? super V> predicate);

    <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function);

    <P, VV> MutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter);

    MutableByteObjectMap<V> withKeyValue(byte key, V value);

    MutableByteObjectMap<V> withoutKey(byte key);

    MutableByteObjectMap<V> withoutAllKeys(ByteIterable keys);

    MutableByteObjectMap<V> asUnmodifiable();

    MutableByteObjectMap<V> asSynchronized();
}
