/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableFloatCollection;
import com.gs.collections.impl.factory.primitive.FloatBags;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableFloatBag
        extends AbstractUnmodifiableFloatCollection
        implements MutableFloatBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableFloatBag(MutableFloatBag bag)
    {
        super(bag);
    }

    private MutableFloatBag getMutableFloatBag()
    {
        return (MutableFloatBag) this.getFloatCollection();
    }

    @Override
    public UnmodifiableFloatBag with(float element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatBag without(float element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatBag withAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatBag withoutAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(float item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(float item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct()
    {
        return this.getMutableFloatBag().sizeDistinct();
    }

    public int occurrencesOf(float item)
    {
        return this.getMutableFloatBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(FloatIntProcedure procedure)
    {
        this.getMutableFloatBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableFloatBag select(FloatPredicate predicate)
    {
        return this.getMutableFloatBag().select(predicate);
    }

    @Override
    public MutableFloatBag reject(FloatPredicate predicate)
    {
        return this.getMutableFloatBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.getMutableFloatBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableFloatBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableFloatBag().hashCode();
    }

    @Override
    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public MutableFloatBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableFloatBag asSynchronized()
    {
        return new SynchronizedFloatBag(this);
    }

    @Override
    public ImmutableFloatBag toImmutable()
    {
        return FloatBags.immutable.withAll(this);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableFloatBag().injectInto(injectedValue, function);
    }
}
