/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.utility.internal.primitive.ShortIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyShortIterate;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 * @since 5.0
 */
public abstract class AbstractLazyShortIterable implements LazyShortIterable
{
    public int size()
    {
        return this.count(ShortPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return ShortIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return ShortIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        ShortIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(short value)
    {
        return this.anySatisfy(ShortPredicates.equal(value));
    }

    public boolean containsAll(short... source)
    {
        return this.containsAll(ShortSets.immutable.of(source));
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.allSatisfy(new ShortPredicate()
        {
            public boolean accept(short value)
            {
                return AbstractLazyShortIterable.this.contains(value);
            }
        });
    }

    public LazyShortIterable select(ShortPredicate predicate)
    {
        return LazyShortIterate.select(this, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate)
    {
        return LazyShortIterate.select(this, ShortPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return LazyShortIterate.collect(this, function);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ShortIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(ShortPredicate predicate)
    {
        return ShortIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return ShortIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return ShortIterableIterate.injectInto(this, injectedValue, function);
    }

    public long sum()
    {
        return ShortIterableIterate.sum(this);
    }

    public short max()
    {
        return ShortIterableIterate.max(this);
    }

    public short maxIfEmpty(short ifEmpty)
    {
        return ShortIterableIterate.maxIfEmpty(this, ifEmpty);
    }

    public short min()
    {
        return ShortIterableIterate.min(this);
    }

    public short minIfEmpty(short ifEmpty)
    {
        return ShortIterableIterate.minIfEmpty(this, ifEmpty);
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public short[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableShortList toSortedList()
    {
        return ShortArrayList.newList(this).sortThis();
    }

    public short[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableShortList toList()
    {
        final MutableShortList list = new ShortArrayList();
        this.forEach(new ShortProcedure()
        {
            public void value(short each)
            {
                list.add(each);
            }
        });
        return list;
    }

    public MutableShortSet toSet()
    {
        final MutableShortSet set = new ShortHashSet();
        this.forEach(new ShortProcedure()
        {
            public void value(short each)
            {
                set.add(each);
            }
        });
        return set;
    }

    public MutableShortBag toBag()
    {
        final MutableShortBag bag = new ShortHashBag();
        this.forEach(new ShortProcedure()
        {
            public void value(short each)
            {
                bag.add(each);
            }
        });
        return bag;
    }

    public LazyShortIterable asLazy()
    {
        return this;
    }
}
