/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableFloatBag;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedFloatCollection;
import com.gs.collections.impl.factory.primitive.FloatBags;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedFloatBag
extends AbstractSynchronizedFloatCollection
implements MutableFloatBag {
    private static final long serialVersionUID = 1L;

    SynchronizedFloatBag(MutableFloatBag bag) {
        super((MutableFloatCollection)bag);
    }

    SynchronizedFloatBag(MutableFloatBag bag, Object newLock) {
        super((MutableFloatCollection)bag, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableFloatBag getMutableFloatBag() {
        return (MutableFloatBag)this.getFloatCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag with(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag without(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag withAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatBag withoutAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(float item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(float item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(float item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(FloatIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag select(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag reject(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }
    }

    public MutableFloatBag asUnmodifiable() {
        return new UnmodifiableFloatBag(this);
    }

    public MutableFloatBag asSynchronized() {
        return this;
    }

    public ImmutableFloatBag toImmutable() {
        return FloatBags.immutable.withAll((FloatIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableFloatBag().injectInto(injectedValue, function);
        }
    }
}

