/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatFloatMap;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.map.primitive.MutableFloatFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatFloatPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.primitive.FloatFloatMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatFloatMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableFloatFloatMap
implements MutableFloatFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatFloatMap map;

    UnmodifiableFloatFloatMap(MutableFloatFloatMap map) {
        this.map = map;
    }

    private boolean isAbsent(float result, float key) {
        return result == 0.0f && !this.containsKey(key);
    }

    private float getIfAbsentThrow(float key) {
        float result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatFloatMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(float key, float value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public float getIfAbsentPut(float key, float value) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPut(float key, FloatFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public float getIfAbsentPutWithKey(float key, FloatToFloatFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> float getIfAbsentPutWith(float key, FloatFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public float updateValue(float key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float get(float key) {
        return this.map.get(key);
    }

    public float getIfAbsent(float key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(float key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatFloatProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<FloatFloatPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableFloatFloatMap select(FloatFloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatFloatMap reject(FloatFloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public FloatIterator floatIterator() {
        return this.map.floatIterator();
    }

    public void forEach(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public double sum() {
        return this.map.sum();
    }

    public float max() {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public float addToValue(float key, float toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    public float[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(float value) {
        return this.map.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.map.toList();
    }

    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableFloatFloatMap withKeyValue(float key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatFloatMap withoutKey(float key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatFloatMap withoutAllKeys(FloatIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatFloatMap asUnmodifiable() {
        return this;
    }

    public MutableFloatFloatMap asSynchronized() {
        return new SynchronizedFloatFloatMap(this);
    }

    public ImmutableFloatFloatMap toImmutable() {
        return FloatFloatMaps.immutable.withAll((FloatFloatMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

