/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.ImmutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import com.gs.collections.impl.set.immutable.primitive.ImmutableTrueFalseSet;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableTrueSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableTrueSet();

    private ImmutableTrueSet() {
    }

    public ImmutableBooleanSet newWith(boolean element) {
        return element ? this : ImmutableTrueFalseSet.INSTANCE;
    }

    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableTrueSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        return elements.contains(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    public BooleanIterator booleanIterator() {
        return new TrueIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(true);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, true);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(true) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(true);
    }

    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        return predicate.accept(true) ? this : ImmutableBooleanEmptySet.INSTANCE;
    }

    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        return predicate.accept(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(true) || ifNone;
    }

    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(true));
    }

    public boolean[] toArray() {
        return new boolean[]{true};
    }

    public boolean contains(boolean value) {
        return value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (item) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (iterator.next()) continue;
            return false;
        }
        return true;
    }

    public BooleanSet freeze() {
        return this;
    }

    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return !other.contains(false) && other.contains(true);
    }

    public int hashCode() {
        return 1231;
    }

    public String toString() {
        return "[true]";
    }

    public String makeString() {
        return "true";
    }

    public String makeString(String separator) {
        return "true";
    }

    public String makeString(String start, String separator, String end) {
        return start + "true" + end;
    }

    public void appendString(Appendable appendable) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("true");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy((BooleanSet)this);
    }

    private static final class TrueIterator
    implements BooleanIterator {
        private int currentIndex;

        private TrueIterator() {
        }

        public boolean next() {
            if (this.currentIndex == 0) {
                ++this.currentIndex;
                return true;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.currentIndex == 0;
        }
    }
}

