/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.feature.sql_server_database;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.etlunit.ProcessDescription;
import org.etlunit.ProcessFacade;
import org.etlunit.RuntimeSupport;
import org.etlunit.TestExecutionError;
import org.etlunit.feature.database.DatabaseImplementation;
import org.etlunit.feature.sql_server_database.SqlCmd;
import org.etlunit.parser.UnEscapist;
import org.etlunit.util.IOUtils;
import org.etlunit.util.StringUtils;
import org.etlunit.util.VelocityUtil;
import org.etlunit.util.regexp.ColumnListExpression;
import org.etlunit.util.regexp.FormatFileColumnExpression;

public class BcpCmd {
    private final File bcpCmd;
    private final String serverName;
    private final String databaseName;
    private final RuntimeSupport runtimeSupport;
    private final SqlCmd sqlCmd;
    private final String columnDelimiter;
    private final String rowDelimiter;

    public BcpCmd(File sqlBinDir, RuntimeSupport runtimeSupport, String serverName, String databaseName, String delimiter, String rowDelimiter) {
        this.bcpCmd = new File(sqlBinDir, "bcp.exe");
        this.sqlCmd = new SqlCmd(sqlBinDir, runtimeSupport);
        this.runtimeSupport = runtimeSupport;
        this.databaseName = databaseName;
        this.serverName = serverName;
        this.columnDelimiter = UnEscapist.escape((String)delimiter);
        this.rowDelimiter = UnEscapist.escape((String)rowDelimiter);
        if (!this.bcpCmd.exists()) {
            throw new IllegalArgumentException("bcp.exe not found");
        }
    }

    public void importCsvData(File dataFile, File formatFile, String targetTableName, String targetTableSchema) throws IOException {
        this.generateFormatFile(targetTableName, targetTableSchema, formatFile);
        ProcessDescription pb = new ProcessDescription(this.bcpCmd.getAbsolutePath()).argument(this.databaseName + "." + targetTableSchema + "." + targetTableName).argument("in").argument(dataFile.getAbsolutePath()).argument("-n").argument("-T").argument("-S").argument(this.serverName).argument("-f").argument(formatFile.getAbsolutePath()).argument("-F").argument("2").argument("-c").argument("-t").argument(this.columnDelimiter).argument("-r").argument(this.rowDelimiter);
        ProcessFacade process = this.runtimeSupport.execute(pb);
        process.waitForCompletion();
        int res = process.getCompletionCode();
        String buffered = process.getInputBuffered().toString();
        if (res != 0) {
            throw new IOException("Could not load data: " + dataFile.getAbsolutePath() + " : " + process.getInputBuffered());
        }
    }

    public List<String> exportSql(String sql, File targetFile) throws Exception {
        String name = targetFile.getName().replace('.', '_');
        HashMap<String, String> bean = new HashMap<String, String>();
        bean.put("databaseName", this.databaseName);
        bean.put("procedureName", name);
        bean.put("sql", sql);
        String str = this.getResourceTemplate("proc_frag", bean);
        File tempScript = this.runtimeSupport.createGeneratedSourceFile("sql-server", name + "_proc.sql");
        IOUtils.writeBufferToFile((File)tempScript, (StringBuffer)new StringBuffer(str));
        this.sqlCmd.executeScript(this.serverName, this.databaseName, tempScript);
        ProcessDescription pb = new ProcessDescription(this.bcpCmd.getAbsolutePath()).argument("exec " + this.databaseName + ".dbo." + name).argument("queryout").argument(targetFile.getAbsolutePath()).argument("-n").argument("-T").argument("-S").argument(this.serverName).argument("-V").argument("90");
        ProcessFacade process = this.runtimeSupport.execute(pb);
        process.waitForCompletion();
        int res = process.getCompletionCode();
        if (res != 0) {
            throw new IOException("Could not execute script: " + targetFile.getAbsolutePath());
        }
        name = name + "_col_export";
        bean.put("tempTableName", name);
        str = this.getResourceTemplate("export_sql_columns", bean);
        tempScript = this.runtimeSupport.createGeneratedSourceFile("sql-server", name + "_proc.sql");
        File tempColumns = this.runtimeSupport.createGeneratedSourceFile("sql-server", name + ".columns");
        IOUtils.writeBufferToFile((File)tempScript, (StringBuffer)new StringBuffer(str));
        this.sqlCmd.executeScript(this.serverName, this.databaseName, tempScript);
        pb = new ProcessDescription(this.bcpCmd.getAbsolutePath()).argument("exec " + this.databaseName + ".dbo." + name).argument("queryout").argument(tempColumns.getAbsolutePath()).argument("-n").argument("-T").argument("-S").argument(this.serverName).argument("-V").argument("90");
        process = this.runtimeSupport.execute(pb);
        process.waitForCompletion();
        res = process.getCompletionCode();
        if (res != 0) {
            throw new IOException("Could not execute export columns script: " + targetFile.getAbsolutePath());
        }
        ArrayList<String> colList = new ArrayList<String>();
        String cols = IOUtils.readFileToString((File)tempColumns);
        ColumnListExpression cle = new ColumnListExpression(cols);
        while (cle.hasNext()) {
            colList.add(cle.getColumnName());
        }
        return colList;
    }

    private String getResourceTemplate(String path, Map bean) throws Exception {
        URL template = this.getClass().getResource("/" + path + ".vm");
        if (template == null) {
            throw new IllegalStateException("Could not find " + path + ".vm template");
        }
        return VelocityUtil.writeTemplate((String)IOUtils.readURLToString((URL)template), (Map)bean);
    }

    public void generateFormatFile(String tableName, String tableSchema, File format) throws IOException {
        ProcessDescription pb = new ProcessDescription(this.bcpCmd.getAbsolutePath()).argument(this.databaseName + "." + tableSchema + "." + tableName).argument("format").argument("nul").argument("-f").argument(format.getAbsolutePath()).argument("-T").argument("-S").argument(this.serverName).argument("-V").argument("90").argument("-x").argument("-w").argument("-t").argument(this.columnDelimiter).argument("-r").argument(this.rowDelimiter);
        ProcessFacade process = this.runtimeSupport.execute(pb);
        process.waitForCompletion();
        int res = process.getCompletionCode();
        if (res != 0) {
            throw new IOException("Could not create format file: " + process.getInputBuffered());
        }
    }

    public List<String> exportTableToCsv(String tableName, String tableSchema, List<String> columns, DatabaseImplementation.ExtractRequest.column_list_mode columnListMode, File data, File format) throws Exception {
        this.generateFormatFile(tableName, tableSchema, format);
        String ff = BcpCmd.readBcpEncodedFileToString(format);
        ArrayList<String> ffColumns = new ArrayList<String>();
        FormatFileColumnExpression ffce = new FormatFileColumnExpression(ff);
        while (ffce.hasNext()) {
            ffColumns.add(ffce.getColumnName());
        }
        if (columnListMode != DatabaseImplementation.ExtractRequest.column_list_mode.none) {
            if (columns == null) {
                throw new IllegalStateException("column-list-mode requires columns");
            }
            switch (columnListMode) {
                case excludes: {
                    for (String col : columns) {
                        if (ffColumns.contains(col)) {
                            ffColumns.remove(col);
                            continue;
                        }
                        throw new TestExecutionError("Column '" + col + "' in exclude list does not exist in the source table: " + ffColumns);
                    }
                    break;
                }
                case includes: {
                    ArrayList<String> newCols = new ArrayList<String>();
                    for (String col : columns) {
                        if (ffColumns.contains(col)) {
                            newCols.add(col);
                            continue;
                        }
                        throw new TestExecutionError("Column '" + col + "' in include list does not exist in the source table: " + ffColumns);
                    }
                    ffColumns = newCols;
                }
            }
        }
        StringBuffer select = new StringBuffer("\nSELECT\n");
        StringBuffer order = new StringBuffer("\nFROM\n\t" + tableSchema + "." + tableName + "\nORDER BY\n");
        boolean first = true;
        for (String col : ffColumns) {
            if (!first) {
                select.append(",\n");
                order.append(",\n");
            } else {
                first = false;
            }
            select.append("\t");
            select.append(col);
            order.append("\t");
            order.append(col);
        }
        HashMap<String, String> bean = new HashMap<String, String>();
        String procName = StringUtils.sanitize((String)data.getName(), (char)'_');
        bean.put("databaseName", this.databaseName);
        bean.put("procedureName", procName);
        bean.put("sql", select.toString() + order.toString() + "\n");
        String str = this.getResourceTemplate("proc_frag", bean);
        File tempScript = this.runtimeSupport.createGeneratedSourceFile("sql-server", procName + "_proc.sql");
        IOUtils.writeBufferToFile((File)tempScript, (StringBuffer)new StringBuffer(str));
        this.sqlCmd.executeScript(this.serverName, this.databaseName, tempScript);
        ProcessDescription pb = new ProcessDescription(this.bcpCmd.getAbsolutePath()).argument("exec " + this.databaseName + "." + tableSchema + "." + procName).argument("queryout").argument(data.getAbsolutePath()).argument("-T").argument("-S").argument(this.serverName).argument("-V").argument("90").argument("-c").argument("-t").argument(this.columnDelimiter).argument("-r").argument(this.rowDelimiter);
        ProcessFacade process = this.runtimeSupport.execute(pb);
        process.waitForCompletion();
        int res = process.getCompletionCode();
        if (res != 0) {
            throw new IOException("Could not execute bcp command: " + process.getInputBuffered());
        }
        return ffColumns;
    }

    static String readBcpEncodedFileToString(File file) throws IOException {
        return new String(IOUtils.readFileToString((File)file).getBytes(), Charset.forName("UTF-16LE"));
    }

    public static enum bcp_direction {
        in,
        out,
        queryout;

    }
}

