/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.feature.sql_server_database;

import java.io.File;
import org.etlunit.ProcessDescription;
import org.etlunit.ProcessFacade;
import org.etlunit.RuntimeSupport;
import org.etlunit.TestExecutionError;

public class SqlCmd {
    private final File sqlCmd;
    private final RuntimeSupport runtimeSupport;

    public SqlCmd(File sqlBinDir, RuntimeSupport runtimeSupport) {
        this.sqlCmd = new File(sqlBinDir, "sqlcmd.exe");
        if (!this.sqlCmd.exists()) {
            throw new IllegalArgumentException("sqlcmd.exe not found");
        }
        this.runtimeSupport = runtimeSupport;
    }

    public void executeScript(String serverName, String databaseName, File scriptFile) throws Exception {
        ProcessDescription pb = new ProcessDescription(this.sqlCmd.getAbsolutePath()).argument("-b").argument("-E").argument("-S").argument(serverName).argument("-d").argument(databaseName).argument("-i").argument(scriptFile.getAbsolutePath());
        ProcessFacade res = this.runtimeSupport.execute(pb);
        res.waitForCompletion();
        if (res.getCompletionCode() != 0) {
            throw new TestExecutionError("Could not execute script: " + scriptFile.getAbsolutePath() + " : " + res.getInputBuffered());
        }
    }
}

