/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.feature.sql_server_database;

import com.google.inject.Injector;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.etlunit.feature.AbstractFeature;
import org.etlunit.feature.FeatureModule;
import org.etlunit.feature.database.DatabaseFeatureModule;
import org.etlunit.feature.database.DatabaseImplementation;
import org.etlunit.feature.sql_server_database.SqlServerDatabaseImplementation;
import org.etlunit.io.FileBuilder;
import org.etlunit.parser.ETLTestValueObject;

@FeatureModule
public class SqlServerDatabaseFeatureModule
extends AbstractFeature {
    private static final List<String> prerequisites = Arrays.asList("logging", "database");
    private DatabaseFeatureModule databaseFeatureModule;

    @Inject
    public void setDatabaseFeature(DatabaseFeatureModule feature) {
        this.databaseFeatureModule = feature;
    }

    public void initialize(Injector inj) {
        ETLTestValueObject value = this.configuration.query("vendor-binary-directory");
        if (value == null) {
            throw new IllegalArgumentException("Configuration property 'vendor-binary-directory' not present");
        }
        File path = new FileBuilder(value.getValueAsString()).subdir("SqlServer").subdir("2008_R2_x86").file();
        this.databaseFeatureModule.addDatabaseImplementation((DatabaseImplementation)this.postCreate((Object)new SqlServerDatabaseImplementation()));
    }

    public List<String> getPrerequisites() {
        return prerequisites;
    }

    public String getFeatureName() {
        return "sql-server-database";
    }
}

