/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.feature.sql_server_database;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.sourceforge.jtds.jdbc.Driver;
import org.etlunit.Log;
import org.etlunit.RuntimeSupport;
import org.etlunit.TestExecutionError;
import org.etlunit.feature.database.BaseDatabaseImplemenation;
import org.etlunit.feature.database.DatabaseConnection;
import org.etlunit.feature.database.DatabaseFeatureModule;
import org.etlunit.feature.database.DatabaseImplementation;
import org.etlunit.feature.database.JDBCClient;
import org.etlunit.feature.database.RelationalDataSet;
import org.etlunit.feature.database.SQLAggregator;
import org.etlunit.parser.ETLTestValueObject;
import org.etlunit.util.IOUtils;
import org.etlunit.util.VelocityUtil;

public class SqlServerDatabaseImplementation
extends BaseDatabaseImplemenation {
    private Log applicationLog;
    private RuntimeSupport runtimeSupport;
    private DatabaseFeatureModule databaseFeatureModule;
    private static final int MASTER = -1;
    private static final int DATABASE = 0;
    private Map<String, RelationalDataSet> identityStatus = new HashMap<String, RelationalDataSet>();

    @Inject
    public void setRuntimeSupport(RuntimeSupport runtimeSupport) {
        this.runtimeSupport = runtimeSupport;
    }

    @Inject
    public void setDatabaseFeatureModule(DatabaseFeatureModule databaseFeatureModule) {
        this.databaseFeatureModule = databaseFeatureModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareConnectionForInsert(Connection connection, RelationalDataSet target, String mode) throws Exception {
        if (mode == null) {
            mode = "[[DEFAULT]]";
        }
        if (target.hasIdentityColumns()) {
            String sql;
            this.applicationLog.info("Enabling identity insert for " + target.getQualifiedName());
            RelationalDataSet currIdent = this.identityStatus.get(mode);
            Statement st = connection.createStatement();
            if (currIdent != null) {
                sql = "SET IDENTITY_INSERT " + currIdent.getQualifiedName() + " OFF";
                try {
                    st.execute(sql);
                }
                catch (SQLException exc) {
                    this.applicationLog.severe("Error disabling identity insert for " + currIdent.getQualifiedName() + " using sql: " + sql, (Throwable)exc);
                }
            }
            sql = "SET IDENTITY_INSERT " + target.getQualifiedName() + " ON";
            try {
                st.execute(sql);
                this.identityStatus.put(mode, target);
            }
            catch (SQLException exc) {
                this.applicationLog.severe("Error enabling identity insert for " + target.getQualifiedName() + " using sql: " + sql, (Throwable)exc);
            }
            finally {
                st.close();
            }
        } else {
            this.applicationLog.info("Identity insert not required for " + target.getQualifiedName());
        }
    }

    @Inject
    public void setLogger(@Named(value="applicationLog") Log log) {
        this.applicationLog = log;
    }

    public DatabaseImplementation.data_format getDataFormatForExtract(ETLTestValueObject operands) {
        return DatabaseImplementation.data_format.delimited;
    }

    public String getImplementationId() {
        return "sql-server";
    }

    public Object processOperation(DatabaseImplementation.operation op, DatabaseImplementation.OperationRequest request) throws UnsupportedOperationException {
        switch (op) {
            case prepareDatabase: {
                this.doPrepareDatabase(request.getPrepareRequest());
                return null;
            }
            default: {
                throw new UnsupportedOperationException();
            }
            case createDatabase: {
                this.doCreateDatabase(request.getInitializeRequest());
                return null;
            }
            case completeDatabaseInitialization: 
        }
        this.doCompleteDatabase(request.getInitializeRequest());
        return null;
    }

    public String getDefaultSchema(DatabaseConnection dc, String mode) {
        return "DBO";
    }

    public DatabaseImplementation.database_state getDatabaseState(DatabaseConnection dc, String mode) {
        return DatabaseImplementation.database_state.pass;
    }

    private void doCompleteDatabase(DatabaseImplementation.InitializeRequest initializeRequest) {
        URL url_materialize_views = ((Object)((Object)this)).getClass().getResource("/materialize_views.vm");
        HashMap map = new HashMap();
        DatabaseConnection databaseConnection = initializeRequest.getConnection();
        String mode = initializeRequest.getMode();
        try {
            String materializeText = IOUtils.readURLToString((URL)url_materialize_views);
            String script = VelocityUtil.writeTemplate((String)materializeText, map);
            String scriptName = "Materialize_Views_" + databaseConnection.getDatabaseName(mode) + ".sql";
            File scriptFile = this.runtimeSupport.createGeneratedSourceFile(this.getImplementationId(), scriptName);
            IOUtils.writeBufferToFile((File)scriptFile, (StringBuffer)new StringBuffer(script));
            this.executeScript(script, databaseConnection, mode, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void executeScript(String script, DatabaseConnection databaseConnection, String mode, boolean master) throws IOException, TestExecutionError {
        final SQLAggregator sqlagg = this.databaseFeatureModule.resolveSQLRef(script);
        this.jdbcClient.useStatement(databaseConnection, mode, new JDBCClient.StatementClient(){

            public void connection(Connection conn, Statement st, DatabaseConnection connection, String mode, int id) throws Exception {
                SQLAggregator.Aggregator statementAggregator = sqlagg.getStatementAggregator();
                while (statementAggregator.hasNext()) {
                    st.execute(statementAggregator.next().getLine());
                }
            }
        }, master ? -1 : 0);
    }

    private void doCreateDatabase(DatabaseImplementation.InitializeRequest initializeRequest) {
        URL url_kill = ((Object)((Object)this)).getClass().getResource("/kill_db.vm");
        URL url_create = ((Object)((Object)this)).getClass().getResource("/create_db.vm");
        try {
            String killText = IOUtils.readURLToString((URL)url_kill);
            HashMap<String, String> map = new HashMap<String, String>();
            DatabaseConnection databaseConnection = initializeRequest.getConnection();
            String mode = initializeRequest.getMode();
            map.put("databaseLogin", databaseConnection.getLoginName(mode));
            map.put("databaseName", databaseConnection.getDatabaseName(mode));
            map.put("databaseUsername", databaseConnection.getLoginName(mode));
            map.put("databasePassword", databaseConnection.getPassword(mode));
            String script = VelocityUtil.writeTemplate((String)killText, map);
            String scriptName = "Kill_Database_" + databaseConnection.getDatabaseName(mode) + ".sql";
            File scriptFile = this.runtimeSupport.createGeneratedSourceFile(this.getImplementationId(), scriptName);
            IOUtils.writeBufferToFile((File)scriptFile, (StringBuffer)new StringBuffer(script));
            this.executeScript(script, databaseConnection, mode, true);
            String createText = IOUtils.readURLToString((URL)url_create);
            script = VelocityUtil.writeTemplate((String)createText, map);
            scriptName = "Create_Database_" + databaseConnection.getDatabaseName(mode) + ".sql";
            scriptFile = this.runtimeSupport.createGeneratedSourceFile(this.getImplementationId(), scriptName);
            IOUtils.writeBufferToFile((File)scriptFile, (StringBuffer)new StringBuffer(script));
            this.executeScript(script, databaseConnection, mode, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void doPrepareDatabase(DatabaseImplementation.PrepareRequest prepareRequest) {
        URL url = ((Object)((Object)this)).getClass().getResource("/purge_db.vm");
        try {
            String purgeText = IOUtils.readURLToString((URL)url);
            DatabaseConnection databaseConnection = prepareRequest.getConnection();
            String mode = prepareRequest.getMode();
            String databaseName = databaseConnection.getDatabaseName(mode);
            String scriptName = "Purge_Database_" + databaseConnection.getDatabaseName(mode) + ".sql";
            File scriptFile = this.runtimeSupport.createGeneratedSourceFile(this.getImplementationId(), scriptName);
            IOUtils.writeBufferToFile((File)scriptFile, (StringBuffer)new StringBuffer(purgeText));
            this.executeScript(purgeText, databaseConnection, mode, false);
        }
        catch (Exception e) {
            throw new IllegalStateException("", e);
        }
    }

    protected String getJdbcUrl(DatabaseConnection dc, String mode, int id) {
        if (id == -1) {
            return "jdbc:jtds:sqlserver://" + dc.getServerName() + "/master";
        }
        return "jdbc:jtds:sqlserver://" + dc.getServerName() + "/" + dc.getDatabaseName(mode);
    }

    protected String getPassword(DatabaseConnection dc, String mode, int id) {
        return id == -1 ? dc.getAdminPassword() : dc.getPassword(mode);
    }

    protected Class getJdbcDriverClass() {
        return Driver.class;
    }

    protected String getLoginName(DatabaseConnection dc, String mode, int id) {
        return id == -1 ? dc.getAdminUserName() : dc.getLoginName(mode);
    }
}

