/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.util.regexp;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormatFileColumnExpression {
    public static final String PATTERN_RAW_TEXT = "COLUMN SOURCE=\"(?'columnOffset'[^\"]+)\" NAME=\"(?'columnName'[^\"]+)\" xsi:type=\"[^\"]+\"";
    public static final String PATTERN_TEXT;
    public static final Pattern pattern;
    private static final Map<String, Integer> groupOffsets;
    private final Matcher matcher;
    private final CharSequence matchText;

    private FormatFileColumnExpression(Matcher pMatcher, CharSequence ch) {
        this.matcher = pMatcher;
        this.matchText = ch;
    }

    public FormatFileColumnExpression(CharSequence ch) {
        this(pattern.matcher(ch), ch);
    }

    public static FormatFileColumnExpression match(CharSequence pText) {
        return new FormatFileColumnExpression(pText);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceAll(RegExpIterator it) {
        String match = ((Object)this.matchText).toString();
        String str = "";
        int end = -1;
        while (this.hasNext()) {
            str = str + match.substring(end == -1 ? 0 : end, this.start());
            str = str + it.replaceMatch(this);
            end = this.end();
        }
        str = str + match.substring(end == -1 ? 0 : end, match.length());
        return str;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean hasNext() {
        return this.matcher.find();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int i) {
        return this.matcher.group(i);
    }

    public FormatFileColumnExpression resetMatch(CharSequence seq) {
        return FormatFileColumnExpression.match(seq);
    }

    public String group(String name) {
        return this.matcher.group(groupOffsets.get(name));
    }

    private static String scope(String text, String name) {
        return text.replaceAll("(\\(\\?')(\\w+')", "$1" + name + ".$2");
    }

    public boolean hasColumnOffset() {
        return this.group("columnOffset") != null;
    }

    public int getColumnOffset() {
        if (!this.hasColumnOffset()) {
            throw new IllegalArgumentException("Property not defined: ColumnOffset");
        }
        return Integer.parseInt(this.group("columnOffset"));
    }

    public boolean hasColumnName() {
        return this.group("columnName") != null;
    }

    public String getColumnName() {
        if (!this.hasColumnName()) {
            throw new IllegalArgumentException("Property not defined: ColumnName");
        }
        return this.group("columnName");
    }

    public String toString() {
        return "{FormatFileColumnExpression, matchText='" + this.matchText + "'}[" + "(columnOffset)=" + (this.hasColumnOffset() ? Integer.valueOf(this.getColumnOffset()) : "null") + ", (columnName)=" + (this.hasColumnName() ? this.getColumnName() : "null") + "]";
    }

    public static void main(String[] argv) {
        System.out.println(PATTERN_TEXT);
    }

    static {
        groupOffsets = new HashMap<String, Integer>();
        PATTERN_TEXT = PATTERN_RAW_TEXT.replaceAll("\\(\\?'[^']+'", "(");
        Pattern cpattern = Pattern.compile("(\\\\)?\\((\\?'([^']+)')?");
        Matcher matcher = cpattern.matcher(PATTERN_RAW_TEXT);
        int groupCount = 1;
        while (matcher.find()) {
            if (matcher.group(1) != null) continue;
            String groupName = matcher.group(3);
            if (groupName != null) {
                groupOffsets.put(groupName, new Integer(groupCount));
            }
            ++groupCount;
        }
        pattern = Pattern.compile(PATTERN_TEXT, 10);
    }

    public static interface RegExpIterator {
        public String replaceMatch(FormatFileColumnExpression var1);
    }
}

