/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.util.regexp;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SchemaMatchExpression {
    public static final String PATTERN_RAW_TEXT = "(^|[^A-Za-z0-9_]+)(?{schemaName})(\\.)";
    private final String parameter_schemaName;
    public final String pattern_text;
    public final Pattern pattern;
    private final Map<String, Integer> groupOffsets = new HashMap<String, Integer>();
    private final Matcher matcher;
    private final CharSequence matchText;

    public SchemaMatchExpression(CharSequence ch, String schemaName) {
        String s_pattern_text = PATTERN_RAW_TEXT.replaceAll("\\(\\?'[^']+'", "(");
        this.parameter_schemaName = schemaName;
        this.pattern_text = s_pattern_text = s_pattern_text.replace("(?{schemaName})", this.parameter_schemaName);
        Pattern cpattern = Pattern.compile("(\\\\)?\\((\\?'([^']+)')?");
        Matcher m = cpattern.matcher(PATTERN_RAW_TEXT);
        int groupCount = 1;
        while (m.find()) {
            if (m.group(1) != null) continue;
            String groupName = m.group(3);
            if (groupName != null) {
                this.groupOffsets.put(groupName, new Integer(groupCount));
            }
            ++groupCount;
        }
        this.pattern = Pattern.compile(this.pattern_text, 10);
        this.matchText = ch;
        this.matcher = this.pattern.matcher(this.matchText);
    }

    public static SchemaMatchExpression match(CharSequence pText, String schemaName) {
        return new SchemaMatchExpression(pText, schemaName);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceAll(RegExpIterator it) {
        String match = ((Object)this.matchText).toString();
        String str = "";
        int end = -1;
        while (this.hasNext()) {
            str = str + match.substring(end == -1 ? 0 : end, this.start());
            str = str + it.replaceMatch(this);
            end = this.end();
        }
        str = str + match.substring(end == -1 ? 0 : end, match.length());
        return str;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean hasNext() {
        return this.matcher.find();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int i) {
        return this.matcher.group(i);
    }

    public SchemaMatchExpression resetMatch(CharSequence seq, String schemaName) {
        return SchemaMatchExpression.match(seq, schemaName);
    }

    public String group(String name) {
        return this.matcher.group(this.groupOffsets.get(name));
    }

    private static String scope(String text, String name) {
        return text.replaceAll("(\\(\\?')(\\w+')", "$1" + name + ".$2");
    }

    public final String getschemaNameParameter() {
        return this.parameter_schemaName;
    }

    public String toString() {
        return "{SchemaMatchExpression, matchText='" + this.matchText + "'}[" + "]";
    }

    public static void main(String[] argv) {
        System.out.println(PATTERN_RAW_TEXT);
    }

    public static interface RegExpIterator {
        public String replaceMatch(SchemaMatchExpression var1);
    }
}

