/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.util.regexp;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableConstraintExpression {
    public static final String PATTERN_RAW_TEXT = "(?'constraintText'[\\s]*ALTER[\\s]*TABLE[\\s]*TST_TGT[\\s]*\\.[\\s]*(?'tableName'[\\w_]+)[\\s]*ADD[\\s]*CONSTRAINT[\\s]*(?'constraintName'[\\w_]+)[\\s]*FOREIGN[\\s]*KEY[\\s]*\\([^\\)]+\\)[\\s]*REFERENCES[\\s]*TST_TGT[\\s]*\\.[\\s]*(?'foreignTableName'[\\w_]+)\\([^\\)]+\\)[\\s]*ON[\\s]*DELETE[\\s]*(NO[\\s+]ACTION|CASCADE)[\\s]*ON[\\s]*UPDATE[\\s]*NO[\\s]*ACTION[\\s]*go[\\s]*)";
    public static final String PATTERN_TEXT;
    public static final Pattern pattern;
    private static final Map<String, Integer> groupOffsets;
    private final Matcher matcher;
    private final CharSequence matchText;

    private TableConstraintExpression(Matcher pMatcher, CharSequence ch) {
        this.matcher = pMatcher;
        this.matchText = ch;
    }

    public TableConstraintExpression(CharSequence ch) {
        this(pattern.matcher(ch), ch);
    }

    public static TableConstraintExpression match(CharSequence pText) {
        return new TableConstraintExpression(pText);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public String replaceAll(String replacement) {
        return this.matcher.replaceAll(replacement);
    }

    public String replaceAll(RegExpIterator it) {
        String match = ((Object)this.matchText).toString();
        String str = "";
        int end = -1;
        while (this.hasNext()) {
            str = str + match.substring(end == -1 ? 0 : end, this.start());
            str = str + it.replaceMatch(this);
            end = this.end();
        }
        str = str + match.substring(end == -1 ? 0 : end, match.length());
        return str;
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean hasNext() {
        return this.matcher.find();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int i) {
        return this.matcher.group(i);
    }

    public TableConstraintExpression resetMatch(CharSequence seq) {
        return TableConstraintExpression.match(seq);
    }

    public String group(String name) {
        return this.matcher.group(groupOffsets.get(name));
    }

    private static String scope(String text, String name) {
        return text.replaceAll("(\\(\\?')(\\w+')", "$1" + name + ".$2");
    }

    public boolean hasConstraintText() {
        return this.group("constraintText") != null;
    }

    public String getConstraintText() {
        if (!this.hasConstraintText()) {
            throw new IllegalArgumentException("Property not defined: ConstraintText");
        }
        return this.group("constraintText");
    }

    public boolean hasTableName() {
        return this.group("tableName") != null;
    }

    public String getTableName() {
        if (!this.hasTableName()) {
            throw new IllegalArgumentException("Property not defined: TableName");
        }
        return this.group("tableName");
    }

    public boolean hasConstraintName() {
        return this.group("constraintName") != null;
    }

    public String getConstraintName() {
        if (!this.hasConstraintName()) {
            throw new IllegalArgumentException("Property not defined: ConstraintName");
        }
        return this.group("constraintName");
    }

    public boolean hasForeignTableName() {
        return this.group("foreignTableName") != null;
    }

    public String getForeignTableName() {
        if (!this.hasForeignTableName()) {
            throw new IllegalArgumentException("Property not defined: ForeignTableName");
        }
        return this.group("foreignTableName");
    }

    public String toString() {
        return "{TableConstraintExpression, matchText='" + this.matchText + "'}[" + "(constraintText)=" + (this.hasConstraintText() ? this.getConstraintText() : "null") + ", (tableName)=" + (this.hasTableName() ? this.getTableName() : "null") + ", (constraintName)=" + (this.hasConstraintName() ? this.getConstraintName() : "null") + ", (foreignTableName)=" + (this.hasForeignTableName() ? this.getForeignTableName() : "null") + "]";
    }

    public static void main(String[] argv) {
        System.out.println(PATTERN_TEXT);
    }

    static {
        groupOffsets = new HashMap<String, Integer>();
        PATTERN_TEXT = PATTERN_RAW_TEXT.replaceAll("\\(\\?'[^']+'", "(");
        Pattern cpattern = Pattern.compile("(\\\\)?\\((\\?'([^']+)')?");
        Matcher matcher = cpattern.matcher(PATTERN_RAW_TEXT);
        int groupCount = 1;
        while (matcher.find()) {
            if (matcher.group(1) != null) continue;
            String groupName = matcher.group(3);
            if (groupName != null) {
                groupOffsets.put(groupName, new Integer(groupCount));
            }
            ++groupCount;
        }
        pattern = Pattern.compile(PATTERN_TEXT, 10);
    }

    public static interface RegExpIterator {
        public String replaceMatch(TableConstraintExpression var1);
    }
}

